/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.scala;

import com.kobylynskyi.graphql.codegen.mapper.GraphQLTypeMapper;
import com.kobylynskyi.graphql.codegen.mapper.ValueMapper;
import com.kobylynskyi.graphql.codegen.model.MappingContext;
import com.kobylynskyi.graphql.codegen.model.NamedDefinition;
import com.kobylynskyi.graphql.codegen.model.graphql.GraphQLOperation;
import com.kobylynskyi.graphql.codegen.utils.Utils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class ScalaGraphQLTypeMapper
implements GraphQLTypeMapper {
    private static final String SCALA_UTIL_LIST = "scala.Seq";
    private static final String SCALA_UTIL_OPTIONAL = "scala.Option";
    private static final Set<String> SCALA_PRIMITIVE_TYPES = new HashSet<String>(Arrays.asList("Byte", "Short", "Int", "Long", "Float", "Double", "Char", "Boolean"));
    private final ValueMapper valueMapper;

    public ScalaGraphQLTypeMapper(ValueMapper valueMapper) {
        this.valueMapper = valueMapper;
    }

    public static boolean isScalaPrimitive(String scalaType) {
        return SCALA_PRIMITIVE_TYPES.contains(scalaType);
    }

    public static boolean isScalaOption(String scalaType) {
        return scalaType.startsWith("scala.Option[") && scalaType.endsWith("]");
    }

    public static boolean isScalaCollection(String scalaType) {
        return scalaType.startsWith("scala.Seq[") && scalaType.endsWith("]");
    }

    public static String getGenericParameter(String scalaType) {
        return scalaType.substring(SCALA_UTIL_LIST.length() + 1, scalaType.length() - 1);
    }

    @Override
    public String wrapIntoList(MappingContext mappingContext, String type, boolean mandatory) {
        return this.getGenericsString(mappingContext, SCALA_UTIL_LIST, type);
    }

    @Override
    public String wrapSuperTypeIntoList(MappingContext mappingContext, String type, boolean mandatory) {
        return this.getGenericsString(mappingContext, SCALA_UTIL_LIST, "_ <: " + type);
    }

    @Override
    public String wrapApiReturnTypeIfRequired(MappingContext mappingContext, NamedDefinition namedDefinition, String parentTypeName) {
        String computedTypeName = namedDefinition.getJavaName();
        if (parentTypeName.equalsIgnoreCase(GraphQLOperation.SUBSCRIPTION.name()) && Utils.isNotBlank(mappingContext.getSubscriptionReturnType())) {
            return this.getGenericsString(mappingContext, mappingContext.getSubscriptionReturnType(), computedTypeName);
        }
        if (!(!Boolean.TRUE.equals(mappingContext.getUseOptionalForNullableReturnTypes()) || namedDefinition.isMandatory() || computedTypeName.startsWith(SCALA_UTIL_LIST) || computedTypeName.startsWith("java.util.List") || computedTypeName.startsWith(SCALA_UTIL_OPTIONAL))) {
            computedTypeName = this.getGenericsString(mappingContext, SCALA_UTIL_OPTIONAL, computedTypeName);
        }
        if (computedTypeName.startsWith(SCALA_UTIL_LIST) && Utils.isNotBlank(mappingContext.getApiReturnListType())) {
            return computedTypeName.replace(SCALA_UTIL_LIST, mappingContext.getApiReturnListType());
        }
        if (Utils.isNotBlank(mappingContext.getApiReturnType())) {
            return this.getGenericsString(mappingContext, mappingContext.getApiReturnType(), computedTypeName);
        }
        return this.getTypeConsideringPrimitive(mappingContext, namedDefinition, computedTypeName);
    }

    @Override
    public boolean isPrimitive(String scalaType) {
        return ScalaGraphQLTypeMapper.isScalaPrimitive(scalaType);
    }

    @Override
    public String getGenericsString(MappingContext mappingContext, String genericType, String typeParameter) {
        if (genericType.contains("%s")) {
            return String.format(genericType, typeParameter);
        }
        return String.format("%s[%s]", genericType, typeParameter);
    }

    @Override
    public boolean addModelValidationAnnotationForType(String possiblyPrimitiveType) {
        return !ScalaGraphQLTypeMapper.isScalaPrimitive(possiblyPrimitiveType);
    }

    @Override
    public ValueMapper getValueMapper() {
        return this.valueMapper;
    }
}

