/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen;

import com.kobylynskyi.graphql.codegen.generators.FilesGenerator;
import com.kobylynskyi.graphql.codegen.generators.FilesGeneratorsFactory;
import com.kobylynskyi.graphql.codegen.mapper.DataModelMapperFactory;
import com.kobylynskyi.graphql.codegen.mapper.MapperFactory;
import com.kobylynskyi.graphql.codegen.model.GeneratedInformation;
import com.kobylynskyi.graphql.codegen.model.MappingConfig;
import com.kobylynskyi.graphql.codegen.model.MappingConfigDefaultValuesInitializer;
import com.kobylynskyi.graphql.codegen.model.MappingConfigValidator;
import com.kobylynskyi.graphql.codegen.model.MappingContext;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedDocument;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedScalarTypeDefinition;
import com.kobylynskyi.graphql.codegen.parser.GraphQLDocumentParser;
import com.kobylynskyi.graphql.codegen.supplier.MappingConfigSupplier;
import com.kobylynskyi.graphql.codegen.utils.Utils;
import graphql.language.ScalarTypeDefinition;
import graphql.language.ScalarTypeExtensionDefinition;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class GraphQLCodegen {
    protected final MappingConfig mappingConfig;
    private final List<String> schemas;
    private final String introspectionResult;
    private final File outputDir;
    private final GeneratedInformation generatedInformation;
    private final DataModelMapperFactory dataModelMapperFactory;

    protected GraphQLCodegen(List<String> schemas, File outputDir, MappingConfig mappingConfig, GeneratedInformation generatedInformation, MapperFactory mapperFactory) {
        this(schemas, null, outputDir, mappingConfig, null, generatedInformation, mapperFactory);
    }

    protected GraphQLCodegen(String introspectionResult, File outputDir, MappingConfig mappingConfig, GeneratedInformation generatedInformation, MapperFactory mapperFactory) {
        this(null, introspectionResult, outputDir, mappingConfig, null, generatedInformation, mapperFactory);
    }

    protected GraphQLCodegen(List<String> schemas, String introspectionResult, File outputDir, MappingConfig mappingConfig, MappingConfigSupplier externalMappingConfigSupplier, MapperFactory mapperFactory) {
        this(schemas, introspectionResult, outputDir, mappingConfig, externalMappingConfigSupplier, new GeneratedInformation(mappingConfig), mapperFactory);
    }

    protected GraphQLCodegen(List<String> schemas, String introspectionResult, File outputDir, MappingConfig mappingConfig, MappingConfigSupplier externalMappingConfigSupplier, GeneratedInformation generatedInformation, MapperFactory mapperFactory) {
        this.schemas = schemas;
        this.introspectionResult = introspectionResult;
        this.outputDir = outputDir;
        this.generatedInformation = generatedInformation;
        this.dataModelMapperFactory = new DataModelMapperFactory(mapperFactory);
        this.mappingConfig = mappingConfig;
        this.mappingConfig.combine(externalMappingConfigSupplier != null ? (MappingConfig)externalMappingConfigSupplier.get() : null);
        this.initDefaultValues(mappingConfig);
        this.validateConfigs(mappingConfig);
        GraphQLCodegen.sanitize(mappingConfig);
    }

    private static void sanitize(MappingConfig mappingConfig) {
        mappingConfig.setModelValidationAnnotation(Utils.replaceLeadingAtSign(mappingConfig.getModelValidationAnnotation()));
        mappingConfig.setResolverArgumentAnnotations(GraphQLCodegen.sanitizeSet(mappingConfig.getResolverArgumentAnnotations()));
        mappingConfig.setParametrizedResolverAnnotations(GraphQLCodegen.sanitizeSet(mappingConfig.getParametrizedResolverAnnotations()));
        mappingConfig.setCustomAnnotationsMapping(GraphQLCodegen.sanitizeMap(mappingConfig.getCustomAnnotationsMapping()));
        mappingConfig.setDirectiveAnnotationsMapping(GraphQLCodegen.sanitizeMap(mappingConfig.getDirectiveAnnotationsMapping()));
        if (mappingConfig.getCustomTypesMapping() != null) {
            mappingConfig.setCustomTypesMapping(new HashMap<String, String>(mappingConfig.getCustomTypesMapping()));
        }
        if (mappingConfig.getCustomTemplates() != null) {
            mappingConfig.setCustomTemplates(new HashMap<String, String>(mappingConfig.getCustomTemplates()));
        }
    }

    private static Set<String> sanitizeSet(Set<String> originalSet) {
        if (originalSet == null) {
            return new HashSet<String>();
        }
        return originalSet.stream().map(Utils::replaceLeadingAtSign).collect(Collectors.toSet());
    }

    private static Map<String, List<String>> sanitizeMap(Map<String, List<String>> multiValueMap) {
        if (multiValueMap == null) {
            return new HashMap<String, List<String>>();
        }
        HashMap<String, List<String>> sanitizedMultiValueMap = new HashMap<String, List<String>>(multiValueMap.size());
        for (Map.Entry<String, List<String>> entry : multiValueMap.entrySet()) {
            List sanitizedValues = null;
            if (entry.getValue() != null) {
                sanitizedValues = entry.getValue().stream().map(Utils::replaceLeadingAtSign).collect(Collectors.toList());
            }
            sanitizedMultiValueMap.put(entry.getKey(), sanitizedValues);
        }
        return sanitizedMultiValueMap;
    }

    protected void initDefaultValues(MappingConfig mappingConfig) {
        MappingConfigDefaultValuesInitializer.initDefaultValues(mappingConfig);
    }

    private void validateConfigs(MappingConfig mappingConfig) {
        MappingConfigValidator.validate(mappingConfig);
    }

    public List<File> generate() throws IOException {
        long startTime = System.currentTimeMillis();
        Utils.deleteDir(this.outputDir);
        Utils.createDirIfAbsent(this.outputDir);
        if (!Utils.isEmpty(this.schemas)) {
            ExtendedDocument document = GraphQLDocumentParser.getDocumentFromSchemas(this.mappingConfig, this.schemas);
            return this.processDefinitions(document, this.schemas.size() + " schema(s)", startTime);
        }
        if (this.introspectionResult != null) {
            ExtendedDocument document = GraphQLDocumentParser.getDocumentFromIntrospectionResult(this.mappingConfig, this.introspectionResult);
            return this.processDefinitions(document, "introspection result", startTime);
        }
        throw new IllegalArgumentException("Either graphql schema path or introspection result path should be supplied");
    }

    private List<File> processDefinitions(ExtendedDocument document, String source, long startTime) {
        this.initCustomTypeMappings(document.getScalarDefinitions());
        MappingContext context = MappingContext.builder().setMappingConfig(this.mappingConfig).setOutputDirectory(this.outputDir).setGeneratedInformation(this.generatedInformation).setDataModelMapperFactory(this.dataModelMapperFactory).setDocument(document).build();
        ArrayList<File> generatedFiles = new ArrayList<File>();
        for (FilesGenerator generator : FilesGeneratorsFactory.getAll(context, this.dataModelMapperFactory)) {
            generatedFiles.addAll(generator.generate());
        }
        this.printOutputResult(source, generatedFiles.size(), System.currentTimeMillis() - startTime);
        return generatedFiles;
    }

    private void printOutputResult(String source, int classesGenerated, long duration) {
        System.out.printf("Generated %d classes from %s in folder %s, took %d ms%n", classesGenerated, source, this.outputDir.getAbsolutePath(), duration);
    }

    protected void initCustomTypeMappings(Collection<ExtendedScalarTypeDefinition> scalarTypeDefinitions) {
        for (ExtendedScalarTypeDefinition definition : scalarTypeDefinitions) {
            if (definition.getDefinition() != null) {
                this.mappingConfig.putCustomTypeMappingIfAbsent(((ScalarTypeDefinition)definition.getDefinition()).getName(), "String");
            }
            for (ScalarTypeExtensionDefinition extension : definition.getExtensions()) {
                this.mappingConfig.putCustomTypeMappingIfAbsent(extension.getName(), "String");
            }
        }
    }
}

