/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.generators;

import com.kobylynskyi.graphql.codegen.GraphQLCodegen;
import com.kobylynskyi.graphql.codegen.generators.FreeMarkerTemplateType;
import com.kobylynskyi.graphql.codegen.model.GeneratedLanguage;
import com.kobylynskyi.graphql.codegen.model.exception.UnableToLoadFreeMarkerTemplateException;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.core.OutputFormat;
import freemarker.core.PlainTextOutputFormat;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.TemplateModel;
import freemarker.template.Version;
import java.io.File;
import java.io.IOException;
import java.util.EnumMap;

class FreeMarkerTemplatesRegistry {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final Version FREEMARKER_TEMPLATE_VERSION = Configuration.VERSION_2_3_31;
    private static final EnumMap<GeneratedLanguage, EnumMap<FreeMarkerTemplateType, Template>> templateMap = new EnumMap(GeneratedLanguage.class);
    private static final Configuration configuration;

    private FreeMarkerTemplatesRegistry() {
    }

    public static Template getTemplateWithLang(GeneratedLanguage generatedLanguage, FreeMarkerTemplateType templateType) {
        return templateMap.get((Object)generatedLanguage).get((Object)templateType);
    }

    private static EnumMap<FreeMarkerTemplateType, Template> getTemplates(Configuration configuration, GeneratedLanguage language) throws IOException {
        EnumMap<FreeMarkerTemplateType, Template> templates = new EnumMap<FreeMarkerTemplateType, Template>(FreeMarkerTemplateType.class);
        for (FreeMarkerTemplateType templateType : FreeMarkerTemplateType.values()) {
            templates.put(templateType, configuration.getTemplate(FreeMarkerTemplatesRegistry.buildTemplatePath(templateType, language)));
        }
        return templates;
    }

    private static String buildTemplatePath(FreeMarkerTemplateType templateType, GeneratedLanguage language) {
        return String.format("templates/%s-lang/%s.ftl", language.name().toLowerCase(), templateType.name().toLowerCase());
    }

    private static Configuration buildFreeMarkerTemplateConfiguration() {
        ClassTemplateLoader classTemplateLoader = new ClassTemplateLoader(GraphQLCodegen.class.getClassLoader(), "");
        return FreeMarkerTemplatesRegistry.buildFreeMarkerTemplateConfiguration((TemplateLoader)classTemplateLoader);
    }

    private static Configuration buildFreeMarkerTemplateConfiguration(TemplateLoader templateLoader) {
        Configuration configuration = new Configuration(FREEMARKER_TEMPLATE_VERSION);
        configuration.setTemplateLoader(templateLoader);
        configuration.setDefaultEncoding(DEFAULT_ENCODING);
        configuration.setOutputFormat((OutputFormat)PlainTextOutputFormat.INSTANCE);
        configuration.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        configuration.setLogTemplateExceptions(false);
        configuration.setWrapUncheckedExceptions(true);
        configuration.setSharedVariable("statics", (TemplateModel)new BeansWrapper(FREEMARKER_TEMPLATE_VERSION).getStaticModels());
        return configuration;
    }

    private static Configuration buildFreeMarkerCustomTemplateConfiguration(File file) throws IOException {
        FileTemplateLoader fileTemplateLoader = new FileTemplateLoader(file);
        return FreeMarkerTemplatesRegistry.buildFreeMarkerTemplateConfiguration((TemplateLoader)fileTemplateLoader);
    }

    public static Template getCustomTemplate(File templateRoot, String templatePath) {
        try {
            return FreeMarkerTemplatesRegistry.buildFreeMarkerCustomTemplateConfiguration(templateRoot).getTemplate(templatePath);
        }
        catch (IOException e) {
            throw new UnableToLoadFreeMarkerTemplateException(e);
        }
    }

    static {
        try {
            configuration = FreeMarkerTemplatesRegistry.buildFreeMarkerTemplateConfiguration();
            templateMap.put(GeneratedLanguage.JAVA, FreeMarkerTemplatesRegistry.getTemplates(configuration, GeneratedLanguage.JAVA));
            templateMap.put(GeneratedLanguage.SCALA, FreeMarkerTemplatesRegistry.getTemplates(configuration, GeneratedLanguage.SCALA));
            templateMap.put(GeneratedLanguage.KOTLIN, FreeMarkerTemplatesRegistry.getTemplates(configuration, GeneratedLanguage.KOTLIN));
        }
        catch (IOException e) {
            throw new UnableToLoadFreeMarkerTemplateException(e);
        }
    }
}

