/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.generators.impl;

import com.kobylynskyi.graphql.codegen.generators.FilesGenerator;
import com.kobylynskyi.graphql.codegen.generators.FreeMarkerTemplateFilesCreator;
import com.kobylynskyi.graphql.codegen.generators.FreeMarkerTemplateType;
import com.kobylynskyi.graphql.codegen.mapper.DataModelMapperFactory;
import com.kobylynskyi.graphql.codegen.mapper.TypeDefinitionToDataModelMapper;
import com.kobylynskyi.graphql.codegen.model.MappingContext;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedObjectTypeDefinition;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TypeGenerator
implements FilesGenerator {
    private final MappingContext mappingContext;
    private final TypeDefinitionToDataModelMapper typeDefinitionMapper;

    public TypeGenerator(MappingContext mappingContext, DataModelMapperFactory dataModelMapperFactory) {
        this.mappingContext = mappingContext;
        this.typeDefinitionMapper = dataModelMapperFactory.getTypeDefinitionMapper();
    }

    @Override
    public List<File> generate() {
        ArrayList<File> generatedFiles = new ArrayList<File>();
        for (ExtendedObjectTypeDefinition definition : this.mappingContext.getDocument().getTypeDefinitions()) {
            generatedFiles.add(this.generate(definition));
        }
        return generatedFiles;
    }

    private File generate(ExtendedObjectTypeDefinition definition) {
        boolean typeAsInterface = this.mappingContext.getTypesAsInterfaces().contains(definition.getName());
        if (!typeAsInterface) {
            typeAsInterface = definition.getDirectiveNames().stream().anyMatch(directiveName -> this.mappingContext.getTypesAsInterfaces().contains("@" + directiveName));
        }
        Map<String, Object> dataModel = this.typeDefinitionMapper.map(this.mappingContext, definition);
        if (typeAsInterface) {
            return FreeMarkerTemplateFilesCreator.create(this.mappingContext, FreeMarkerTemplateType.INTERFACE, dataModel);
        }
        return FreeMarkerTemplateFilesCreator.create(this.mappingContext, FreeMarkerTemplateType.TYPE, dataModel);
    }
}

