/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.mapper;

import com.kobylynskyi.graphql.codegen.mapper.AnnotationsMapper;
import com.kobylynskyi.graphql.codegen.mapper.DataModelMapper;
import com.kobylynskyi.graphql.codegen.mapper.FieldDefinitionToParameterMapper;
import com.kobylynskyi.graphql.codegen.mapper.GraphQLTypeMapper;
import com.kobylynskyi.graphql.codegen.mapper.MapperFactory;
import com.kobylynskyi.graphql.codegen.mapper.UnknownFieldsSupport;
import com.kobylynskyi.graphql.codegen.model.MappingContext;
import com.kobylynskyi.graphql.codegen.model.ParameterDefinition;
import com.kobylynskyi.graphql.codegen.model.builders.JavaDocBuilder;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedDefinition;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedDocument;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedObjectTypeDefinition;
import com.kobylynskyi.graphql.codegen.utils.Utils;
import graphql.language.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class TypeDefinitionToDataModelMapper
implements UnknownFieldsSupport {
    private final GraphQLTypeMapper graphQLTypeMapper;
    private final AnnotationsMapper annotationsMapper;
    private final DataModelMapper dataModelMapper;
    private final FieldDefinitionToParameterMapper fieldDefinitionToParameterMapper;

    public TypeDefinitionToDataModelMapper(MapperFactory mapperFactory, FieldDefinitionToParameterMapper fieldDefinitionToParameterMapper) {
        this.graphQLTypeMapper = mapperFactory.getGraphQLTypeMapper();
        this.annotationsMapper = mapperFactory.getAnnotationsMapper();
        this.dataModelMapper = mapperFactory.getDataModelMapper();
        this.fieldDefinitionToParameterMapper = fieldDefinitionToParameterMapper;
    }

    private static ParameterDefinition merge(ParameterDefinition typeDef, ParameterDefinition interfaceDef) {
        typeDef.setDefinitionInParentType(interfaceDef);
        if (Utils.isEmpty(typeDef.getAnnotations())) {
            typeDef.setAnnotations(interfaceDef.getAnnotations());
        }
        if (Utils.isEmpty(typeDef.getJavaDoc())) {
            typeDef.setJavaDoc(interfaceDef.getJavaDoc());
        }
        return typeDef;
    }

    public Map<String, Object> map(MappingContext mappingContext, ExtendedObjectTypeDefinition definition) {
        ExtendedDocument document = mappingContext.getDocument();
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        dataModel.put("package", DataModelMapper.getModelPackageName(mappingContext));
        dataModel.put("className", this.dataModelMapper.getModelClassNameWithPrefixAndSuffix(mappingContext, definition));
        dataModel.put("javaDoc", JavaDocBuilder.build(definition));
        dataModel.put("implements", this.getInterfaces(mappingContext, definition));
        dataModel.put("annotations", this.annotationsMapper.getAnnotations(mappingContext, definition));
        dataModel.put("fields", this.getFields(mappingContext, definition, document));
        dataModel.put("builder", mappingContext.getGenerateBuilder());
        dataModel.put("equalsAndHashCode", mappingContext.getGenerateEqualsAndHashCode());
        dataModel.put("immutableModels", mappingContext.getGenerateImmutableModels());
        dataModel.put("toString", mappingContext.getGenerateToString());
        dataModel.put("toStringForRequest", mappingContext.getGenerateClient());
        dataModel.put("generatedAnnotation", mappingContext.getAddGeneratedAnnotation());
        dataModel.put("generatedInfo", mappingContext.getGeneratedInformation());
        dataModel.put("enumImportItSelfInScala", mappingContext.getEnumImportItSelfInScala());
        dataModel.put("parentInterfaceProperties", mappingContext.getParentInterfaceProperties());
        dataModel.put("generateModelOpenClasses", mappingContext.isGenerateModelOpenClasses());
        dataModel.put("initializeNullableTypes", mappingContext.isInitializeNullableTypes());
        dataModel.put("generateSealedInterfaces", mappingContext.isGenerateSealedInterfaces());
        dataModel.put("supportUnknownFields", mappingContext.isSupportUnknownFields());
        dataModel.put("unknownFieldsPropertyName", mappingContext.getUnknownFieldsPropertyName());
        dataModel.put("generateNoArgsConstructorOnly", mappingContext.isGenerateNoArgsConstructorOnly());
        return dataModel;
    }

    private Collection<ParameterDefinition> getFields(MappingContext mappingContext, ExtendedObjectTypeDefinition typeDefinition, ExtendedDocument document) {
        LinkedHashMap allParameters = new LinkedHashMap();
        this.fieldDefinitionToParameterMapper.mapFields(mappingContext, typeDefinition.getFieldDefinitions(), typeDefinition).forEach(p -> allParameters.put(p.getName(), p));
        DataModelMapper.getInterfacesOfType(typeDefinition, document).stream().map(i -> this.fieldDefinitionToParameterMapper.mapFields(mappingContext, i.getFieldDefinitions(), (ExtendedDefinition<?, ?>)i)).flatMap(Collection::stream).forEach(paramDef -> allParameters.merge(paramDef.getName(), paramDef, TypeDefinitionToDataModelMapper::merge));
        this.createUnknownFields(mappingContext).ifPresent(unknownFields -> allParameters.put(mappingContext.getUnknownFieldsPropertyName(), unknownFields));
        return allParameters.values();
    }

    private Set<String> getInterfaces(MappingContext mappingContext, ExtendedObjectTypeDefinition definition) {
        List unionsNames = mappingContext.getDocument().getUnionDefinitions().stream().filter(union -> union.isDefinitionPartOfUnion(definition)).map(ExtendedDefinition::getName).map(unionName -> DataModelMapper.getModelClassNameWithPrefixAndSuffix(mappingContext, unionName)).collect(Collectors.toList());
        Set interfaceNames = definition.getImplements().stream().map(anImplement -> this.graphQLTypeMapper.getLanguageType(mappingContext, (Type<?>)anImplement)).collect(Collectors.toSet());
        LinkedHashSet<String> allInterfaces = new LinkedHashSet<String>();
        allInterfaces.addAll(unionsNames);
        allInterfaces.addAll(interfaceNames);
        return allInterfaces;
    }
}

