/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.mapper;

import com.kobylynskyi.graphql.codegen.mapper.DataModelMapper;
import com.kobylynskyi.graphql.codegen.mapper.ValueFormatter;
import com.kobylynskyi.graphql.codegen.model.MappingContext;
import graphql.language.ArrayValue;
import graphql.language.BooleanValue;
import graphql.language.EnumValue;
import graphql.language.FloatValue;
import graphql.language.IntValue;
import graphql.language.ListType;
import graphql.language.NonNullType;
import graphql.language.NullValue;
import graphql.language.ObjectValue;
import graphql.language.StringValue;
import graphql.language.Type;
import graphql.language.TypeName;
import graphql.language.Value;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class ValueMapper {
    private static final String NULL_STRING = "null";
    private final ValueFormatter valueFormatter;
    private final DataModelMapper dataModelMapper;

    public ValueMapper(ValueFormatter valueFormatter, DataModelMapper dataModelMapper) {
        this.valueFormatter = valueFormatter;
        this.dataModelMapper = dataModelMapper;
    }

    private static String mapBoolean(BooleanValue value) {
        return value.isValue() ? "true" : "false";
    }

    private static String mapInt(MappingContext mappingContext, IntValue value, Type<?> graphQLType) {
        if (graphQLType instanceof TypeName) {
            String customType = mappingContext.getCustomTypesMapping().get("Long");
            String typeName = ((TypeName)graphQLType).getName();
            if ("Long".equals(typeName) && ("java.lang.Long".equals(customType) || "Long".equals(customType))) {
                return String.valueOf(value.getValue()).concat("L");
            }
        }
        if (graphQLType instanceof NonNullType) {
            return ValueMapper.mapInt(mappingContext, value, ((NonNullType)graphQLType).getType());
        }
        return String.valueOf(value.getValue());
    }

    private static String mapFloat(FloatValue value) {
        return String.valueOf(value.getValue());
    }

    private static String mapString(StringValue value) {
        return "\"" + value.getValue() + "\"";
    }

    public String map(MappingContext mappingContext, Value<?> value, Type<?> graphQLType) {
        return this.map(mappingContext, value, graphQLType, null);
    }

    public String map(MappingContext mappingContext, Value<?> value, Type<?> graphQLType, String formatter) {
        if (value instanceof NullValue) {
            return ValueFormatter.format(NULL_STRING, formatter);
        }
        if (value instanceof BooleanValue) {
            return ValueFormatter.format(ValueMapper.mapBoolean((BooleanValue)value), formatter);
        }
        if (value instanceof IntValue) {
            return ValueFormatter.format(ValueMapper.mapInt(mappingContext, (IntValue)value, graphQLType), formatter);
        }
        if (value instanceof FloatValue) {
            return ValueFormatter.format(ValueMapper.mapFloat((FloatValue)value), formatter);
        }
        if (value instanceof StringValue) {
            return ValueFormatter.format(ValueMapper.mapString((StringValue)value), formatter);
        }
        if (value instanceof EnumValue) {
            return ValueFormatter.format(this.mapEnum(mappingContext, (EnumValue)value, graphQLType), formatter);
        }
        if (value instanceof ObjectValue) {
            return null;
        }
        if (value instanceof ArrayValue) {
            return this.mapArray(mappingContext, (ArrayValue)value, graphQLType, formatter);
        }
        return null;
    }

    private String mapEnum(MappingContext mappingContext, EnumValue value, Type<?> graphQLType) {
        if (graphQLType == null) {
            String typeName = value.getName();
            return mappingContext.getCustomTypesMapping().getOrDefault(typeName, typeName);
        }
        if (graphQLType instanceof TypeName) {
            String typeName = ((TypeName)graphQLType).getName();
            typeName = mappingContext.getCustomTypesMapping().getOrDefault(typeName, DataModelMapper.getModelClassNameWithPrefixAndSuffix(mappingContext, typeName));
            return typeName + "." + this.dataModelMapper.capitalizeIfRestricted(mappingContext, value.getName());
        }
        if (graphQLType instanceof NonNullType) {
            return this.mapEnum(mappingContext, value, ((NonNullType)graphQLType).getType());
        }
        throw new IllegalArgumentException("Unexpected Enum value for list type");
    }

    private String mapArray(MappingContext mappingContext, ArrayValue value, Type<?> graphQLType, String formatter) {
        if (graphQLType == null || graphQLType instanceof ListType) {
            List values = value.getValues();
            if (values.isEmpty()) {
                return this.valueFormatter.formatList(Collections.emptyList(), formatter);
            }
            Type elementType = null;
            if (graphQLType != null) {
                elementType = ((ListType)graphQLType).getType();
            }
            Type listElementType = elementType;
            return this.valueFormatter.formatList(values.stream().map(v -> this.map(mappingContext, (Value<?>)v, (Type<?>)listElementType, formatter)).collect(Collectors.toList()), formatter);
        }
        if (graphQLType instanceof NonNullType) {
            return this.mapArray(mappingContext, value, ((NonNullType)graphQLType).getType(), formatter);
        }
        throw new IllegalArgumentException("Unexpected array default value for non-list type");
    }
}

