/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.model;

import com.kobylynskyi.graphql.codegen.mapper.DataModelMapper;
import com.kobylynskyi.graphql.codegen.mapper.DataModelMapperFactory;
import com.kobylynskyi.graphql.codegen.mapper.FieldDefinitionToParameterMapper;
import com.kobylynskyi.graphql.codegen.model.ApiInterfaceStrategy;
import com.kobylynskyi.graphql.codegen.model.ApiNamePrefixStrategy;
import com.kobylynskyi.graphql.codegen.model.ApiRootInterfaceStrategy;
import com.kobylynskyi.graphql.codegen.model.GeneratedInformation;
import com.kobylynskyi.graphql.codegen.model.GeneratedLanguage;
import com.kobylynskyi.graphql.codegen.model.GraphQLCodegenConfiguration;
import com.kobylynskyi.graphql.codegen.model.MappingConfig;
import com.kobylynskyi.graphql.codegen.model.ParameterDefinition;
import com.kobylynskyi.graphql.codegen.model.RelayConfig;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedDefinition;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedDocument;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedEnumTypeDefinition;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedFieldDefinition;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedInterfaceTypeDefinition;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedObjectTypeDefinition;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class MappingContext
implements GraphQLCodegenConfiguration {
    private final File outputDirectory;
    private final MappingConfig config;
    private final ExtendedDocument document;
    private final Set<String> typesUnionsInterfacesNames;
    private final Set<String> interfacesName;
    private final Set<String> unionsName;
    private final Set<String> operationsName;
    private final Set<String> inputsName;
    private final Map<String, Set<String>> interfaceChildren;
    private final GeneratedInformation generatedInformation;
    private final DataModelMapperFactory dataModelMapperFactory;
    private Set<String> enumImportItSelfInScala;
    private Map<String, Set<String>> parentInterfaceProperties;
    private Set<String> fieldNamesWithResolvers;

    private MappingContext(File outputDirectory, MappingConfig mappingConfig, ExtendedDocument document, GeneratedInformation generatedInformation, DataModelMapperFactory dataModelMapperFactory) {
        this.outputDirectory = outputDirectory;
        this.config = mappingConfig;
        this.document = document;
        this.typesUnionsInterfacesNames = document.getTypesUnionsInterfacesNames();
        this.interfacesName = document.getInterfacesNames();
        this.unionsName = document.getUnionsNames();
        this.inputsName = document.getInputDefinitions().stream().map(ExtendedDefinition::getName).collect(Collectors.toSet());
        this.interfaceChildren = document.getInterfaceChildren();
        this.generatedInformation = generatedInformation;
        this.operationsName = document.getOperationsNames();
        this.dataModelMapperFactory = dataModelMapperFactory;
    }

    @Override
    public GeneratedLanguage getGeneratedLanguage() {
        return this.config.getGeneratedLanguage();
    }

    @Override
    public Boolean isGenerateModelOpenClasses() {
        return this.config.isGenerateModelOpenClasses();
    }

    @Override
    public Boolean isInitializeNullableTypes() {
        return this.config.isInitializeNullableTypes();
    }

    @Override
    public Boolean isGenerateSealedInterfaces() {
        return this.config.isGenerateSealedInterfaces();
    }

    @Override
    public Map<String, String> getCustomTypesMapping() {
        return this.config.getCustomTypesMapping();
    }

    @Override
    public File getCustomTemplatesRoot() {
        return this.config.getCustomTemplatesRoot();
    }

    @Override
    public Map<String, String> getCustomTemplates() {
        return this.config.getCustomTemplates();
    }

    @Override
    public Map<String, List<String>> getCustomAnnotationsMapping() {
        return this.config.getCustomAnnotationsMapping();
    }

    @Override
    public Map<String, List<String>> getDirectiveAnnotationsMapping() {
        return this.config.getDirectiveAnnotationsMapping();
    }

    @Override
    public Boolean getGenerateApis() {
        return this.config.getGenerateApis();
    }

    @Override
    public Boolean getGenerateModelsForRootTypes() {
        return this.config.getGenerateModelsForRootTypes();
    }

    @Override
    public ApiRootInterfaceStrategy getApiRootInterfaceStrategy() {
        return this.config.getApiRootInterfaceStrategy();
    }

    @Override
    public ApiInterfaceStrategy getApiInterfaceStrategy() {
        return this.config.getApiInterfaceStrategy();
    }

    @Override
    public String getPackageName() {
        return this.config.getPackageName();
    }

    @Override
    public String getApiPackageName() {
        return this.config.getApiPackageName();
    }

    @Override
    public String getModelPackageName() {
        return this.config.getModelPackageName();
    }

    @Override
    public String getModelNamePrefix() {
        return this.config.getModelNamePrefix();
    }

    @Override
    public String getModelNameSuffix() {
        return this.config.getModelNameSuffix();
    }

    @Override
    public ApiNamePrefixStrategy getApiNamePrefixStrategy() {
        return this.config.getApiNamePrefixStrategy();
    }

    @Override
    public String getApiNamePrefix() {
        return this.config.getApiNamePrefix();
    }

    @Override
    public String getApiNameSuffix() {
        return this.config.getApiNameSuffix();
    }

    @Override
    public String getModelValidationAnnotation() {
        return this.config.getModelValidationAnnotation();
    }

    @Override
    public String getApiReturnType() {
        return this.config.getApiReturnType();
    }

    @Override
    public String getApiReturnListType() {
        return this.config.getApiReturnListType();
    }

    @Override
    public String getSubscriptionReturnType() {
        return this.config.getSubscriptionReturnType();
    }

    @Override
    public Boolean getGenerateBuilder() {
        return this.config.getGenerateBuilder();
    }

    @Override
    public Boolean getGenerateEqualsAndHashCode() {
        return this.config.getGenerateEqualsAndHashCode();
    }

    @Override
    public Boolean getGenerateImmutableModels() {
        return this.config.getGenerateImmutableModels();
    }

    @Override
    public Boolean getGenerateToString() {
        return this.config.getGenerateToString();
    }

    @Override
    public Boolean getGenerateParameterizedFieldsResolvers() {
        return this.config.getGenerateParameterizedFieldsResolvers();
    }

    @Override
    public String getTypeResolverPrefix() {
        return this.config.getTypeResolverPrefix();
    }

    @Override
    public String getTypeResolverSuffix() {
        return this.config.getTypeResolverSuffix();
    }

    @Override
    public Boolean getGenerateExtensionFieldsResolvers() {
        return this.config.getGenerateExtensionFieldsResolvers();
    }

    @Override
    public Boolean getGenerateDataFetchingEnvironmentArgumentInApis() {
        return this.config.getGenerateDataFetchingEnvironmentArgumentInApis();
    }

    @Override
    public Boolean getGenerateApisWithThrowsException() {
        return this.config.getGenerateApisWithThrowsException();
    }

    @Override
    public Boolean getGenerateApisWithSuspendFunctions() {
        return this.config.getGenerateApisWithSuspendFunctions();
    }

    @Override
    public Boolean getAddGeneratedAnnotation() {
        return this.config.getAddGeneratedAnnotation();
    }

    @Override
    public Boolean getGenerateJacksonTypeIdResolver() {
        return this.config.getGenerateJacksonTypeIdResolver();
    }

    @Override
    public RelayConfig getRelayConfig() {
        return this.config.getRelayConfig();
    }

    @Override
    public Boolean getUseOptionalForNullableReturnTypes() {
        return this.config.getUseOptionalForNullableReturnTypes();
    }

    @Override
    public Boolean getUseWrapperForNullableInputTypes() {
        return this.config.getUseWrapperForNullableInputTypes();
    }

    @Override
    public Set<String> getFieldsWithResolvers() {
        return this.config.getFieldsWithResolvers();
    }

    @Override
    public Set<String> getFieldsWithoutResolvers() {
        return this.config.getFieldsWithoutResolvers();
    }

    @Override
    public Set<String> getFieldsToExcludeFromGeneration() {
        return this.config.getFieldsToExcludeFromGeneration();
    }

    @Override
    public Set<String> getFieldsWithDataFetcherResult() {
        return this.config.getFieldsWithDataFetcherResult();
    }

    @Override
    public Boolean getGenerateClient() {
        return this.config.getGenerateClient();
    }

    @Override
    public String getRequestSuffix() {
        return this.config.getRequestSuffix();
    }

    @Override
    public String getResponseSuffix() {
        return this.config.getResponseSuffix();
    }

    @Override
    public String getResponseProjectionSuffix() {
        return this.config.getResponseProjectionSuffix();
    }

    @Override
    public String getParametrizedInputSuffix() {
        return this.config.getParametrizedInputSuffix();
    }

    @Override
    public String getQueryResolverParentInterface() {
        return this.config.getQueryResolverParentInterface();
    }

    @Override
    public String getMutationResolverParentInterface() {
        return this.config.getMutationResolverParentInterface();
    }

    @Override
    public String getSubscriptionResolverParentInterface() {
        return this.config.getSubscriptionResolverParentInterface();
    }

    @Override
    public String getResolverParentInterface() {
        return this.config.getResolverParentInterface();
    }

    @Override
    public Boolean getGenerateAllMethodInProjection() {
        return this.config.getGenerateAllMethodInProjection();
    }

    @Override
    public Integer getResponseProjectionMaxDepth() {
        return this.config.getResponseProjectionMaxDepth();
    }

    @Override
    public Set<String> getUseObjectMapperForRequestSerialization() {
        return this.config.getUseObjectMapperForRequestSerialization();
    }

    @Override
    public Set<String> getTypesAsInterfaces() {
        return this.config.getTypesAsInterfaces();
    }

    @Override
    public Set<String> getResolverArgumentAnnotations() {
        return this.config.getResolverArgumentAnnotations();
    }

    @Override
    public Set<String> getParametrizedResolverAnnotations() {
        return this.config.getParametrizedResolverAnnotations();
    }

    @Override
    public Boolean isSupportUnknownFields() {
        return this.config.isSupportUnknownFields();
    }

    @Override
    public String getUnknownFieldsPropertyName() {
        return this.config.getUnknownFieldsPropertyName();
    }

    @Override
    public String getGeneratedAnnotation() {
        return this.config.getGeneratedAnnotation();
    }

    @Override
    public Boolean isGenerateNoArgsConstructorOnly() {
        return this.config.isGenerateNoArgsConstructorOnly();
    }

    @Override
    public Boolean isGenerateModelsWithPublicFields() {
        return this.config.isGenerateModelsWithPublicFields();
    }

    public ExtendedDocument getDocument() {
        return this.document;
    }

    public Set<String> getTypesUnionsInterfacesNames() {
        return this.typesUnionsInterfacesNames;
    }

    public Set<String> getInterfacesName() {
        return this.interfacesName;
    }

    public Set<String> getUnionsNames() {
        return this.unionsName;
    }

    public Set<String> getOperationsName() {
        return this.operationsName;
    }

    public Set<String> getInputsName() {
        return this.inputsName;
    }

    public Map<String, Set<String>> getInterfaceChildren() {
        return this.interfaceChildren;
    }

    public GeneratedInformation getGeneratedInformation() {
        return this.generatedInformation;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public Set<String> getEnumImportItSelfInScala() {
        if (GeneratedLanguage.SCALA.equals((Object)this.config.getGeneratedLanguage()) && this.enumImportItSelfInScala == null) {
            this.enumImportItSelfInScala = this.document.getEnumDefinitions().stream().map(this::getModelClassNameWithPrefixAndSuffix).collect(Collectors.toSet());
        }
        return this.enumImportItSelfInScala;
    }

    public Map<String, Set<String>> getParentInterfaceProperties() {
        if ((GeneratedLanguage.SCALA.equals((Object)this.config.getGeneratedLanguage()) || GeneratedLanguage.KOTLIN.equals((Object)this.config.getGeneratedLanguage())) && this.parentInterfaceProperties == null) {
            this.parentInterfaceProperties = new HashMap<String, Set<String>>();
            for (ExtendedInterfaceTypeDefinition interfaceDef : this.document.getInterfaceDefinitions()) {
                String clazzName = this.getModelClassNameWithPrefixAndSuffix(interfaceDef);
                Set fields = this.getFields(interfaceDef.getFieldDefinitions(), interfaceDef).stream().map(ParameterDefinition::getName).collect(Collectors.toSet());
                if (this.parentInterfaceProperties.containsKey(clazzName)) {
                    this.parentInterfaceProperties.get(clazzName).addAll(fields);
                    continue;
                }
                this.parentInterfaceProperties.put(clazzName, fields);
            }
        }
        return this.parentInterfaceProperties;
    }

    public Set<String> getFieldNamesWithResolvers() {
        if (this.fieldNamesWithResolvers == null) {
            this.fieldNamesWithResolvers = new HashSet<String>();
            for (ExtendedObjectTypeDefinition extendedObjectTypeDefinition : this.document.getTypeDefinitions()) {
                extendedObjectTypeDefinition.getFieldDefinitions().stream().filter(fieldDef -> FieldDefinitionToParameterMapper.generateResolversForField(this, fieldDef, extendedObjectTypeDefinition)).forEach(fieldDef -> this.fieldNamesWithResolvers.add(extendedObjectTypeDefinition.getName() + "." + fieldDef.getName()));
            }
            for (ExtendedInterfaceTypeDefinition extendedInterfaceTypeDefinition : this.document.getInterfaceDefinitions()) {
                extendedInterfaceTypeDefinition.getFieldDefinitions().stream().filter(fieldDef -> FieldDefinitionToParameterMapper.generateResolversForField(this, fieldDef, extendedInterfaceTypeDefinition)).forEach(fieldDef -> this.fieldNamesWithResolvers.add(extendedInterfaceTypeDefinition.getName() + "." + fieldDef.getName()));
            }
        }
        return this.fieldNamesWithResolvers;
    }

    private String getModelClassNameWithPrefixAndSuffix(ExtendedEnumTypeDefinition extendedEnumTypeDefinition) {
        return DataModelMapper.getModelClassNameWithPrefixAndSuffix(this, extendedEnumTypeDefinition.getName());
    }

    private String getModelClassNameWithPrefixAndSuffix(ExtendedDefinition<?, ?> extendedDefinition) {
        return this.dataModelMapperFactory.getMapperFactory().getDataModelMapper().getModelClassNameWithPrefixAndSuffix(this, extendedDefinition);
    }

    private List<ParameterDefinition> getFields(List<ExtendedFieldDefinition> fieldDefinitions, ExtendedDefinition<?, ?> parentDefinition) {
        return this.dataModelMapperFactory.getFieldDefToParamMapper().mapFields(this, fieldDefinitions, parentDefinition);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private File outputDirectory;
        private MappingConfig mappingConfig;
        private ExtendedDocument document;
        private GeneratedInformation generatedInformation;
        private DataModelMapperFactory dataModelMapperFactory;

        private Builder() {
        }

        public Builder setOutputDirectory(File outputDirectory) {
            this.outputDirectory = outputDirectory;
            return this;
        }

        public Builder setMappingConfig(MappingConfig mappingConfig) {
            this.mappingConfig = mappingConfig;
            return this;
        }

        public Builder setDocument(ExtendedDocument document) {
            this.document = document;
            return this;
        }

        public Builder setGeneratedInformation(GeneratedInformation generatedInformation) {
            this.generatedInformation = generatedInformation;
            return this;
        }

        public Builder setDataModelMapperFactory(DataModelMapperFactory dataModelMapperFactory) {
            this.dataModelMapperFactory = dataModelMapperFactory;
            return this;
        }

        public MappingContext build() {
            return new MappingContext(this.outputDirectory, this.mappingConfig, this.document, this.generatedInformation, this.dataModelMapperFactory);
        }
    }
}

