/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.scala;

import com.kobylynskyi.graphql.codegen.mapper.GraphQLTypeMapper;
import com.kobylynskyi.graphql.codegen.model.MappingContext;
import com.kobylynskyi.graphql.codegen.model.NamedDefinition;
import com.kobylynskyi.graphql.codegen.model.graphql.GraphQLOperation;
import com.kobylynskyi.graphql.codegen.utils.Utils;
import graphql.language.InputValueDefinition;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ScalaGraphQLTypeMapper
extends GraphQLTypeMapper {
    private static final String SCALA_UTIL_LIST = "scala.Seq";
    private static final Pattern SCALA_UTIL_LIST_ELEMENT_REGEX = Pattern.compile("scala\\.Seq\\[(.+)]");
    private static final String SCALA_UTIL_OPTIONAL = "scala.Option";
    private static final Set<String> SCALA_PRIMITIVE_TYPES = new HashSet<String>(Arrays.asList("Byte", "Short", "Int", "Long", "Float", "Double", "Char", "Boolean"));

    public static boolean isScalaPrimitive(String scalaType) {
        return SCALA_PRIMITIVE_TYPES.contains(scalaType);
    }

    public static boolean isScalaOption(String scalaType) {
        return scalaType.startsWith("scala.Option[") && scalaType.endsWith("]");
    }

    public static boolean isScalaCollection(String scalaType) {
        return scalaType.startsWith("scala.Seq[") && scalaType.endsWith("]");
    }

    public static String getGenericParameter(String scalaType) {
        return scalaType.substring(SCALA_UTIL_LIST.length() + 1, scalaType.length() - 1);
    }

    @Override
    public String wrapIntoList(MappingContext mappingContext, String type, boolean mandatory) {
        return this.getGenericsString(mappingContext, SCALA_UTIL_LIST, type);
    }

    @Override
    public String wrapSuperTypeIntoList(MappingContext mappingContext, String type, boolean mandatory) {
        return this.getGenericsString(mappingContext, SCALA_UTIL_LIST, "_ <: " + type);
    }

    @Override
    public String wrapApiReturnTypeIfRequired(MappingContext mappingContext, NamedDefinition namedDefinition, String parentTypeName) {
        String computedTypeName = namedDefinition.getJavaName();
        if (parentTypeName.equalsIgnoreCase(GraphQLOperation.SUBSCRIPTION.name()) && Utils.isNotBlank(mappingContext.getSubscriptionReturnType())) {
            return this.getGenericsString(mappingContext, mappingContext.getSubscriptionReturnType(), computedTypeName);
        }
        if (!(!Boolean.TRUE.equals(mappingContext.getUseOptionalForNullableReturnTypes()) || namedDefinition.isMandatory() || computedTypeName.startsWith(SCALA_UTIL_LIST) || computedTypeName.startsWith("java.util.List") || computedTypeName.startsWith(SCALA_UTIL_OPTIONAL))) {
            computedTypeName = this.getGenericsString(mappingContext, SCALA_UTIL_OPTIONAL, computedTypeName);
        }
        if (computedTypeName.startsWith(SCALA_UTIL_LIST) && Utils.isNotBlank(mappingContext.getApiReturnListType())) {
            if (mappingContext.getApiReturnListType().contains("{{TYPE}}")) {
                Matcher matcher = SCALA_UTIL_LIST_ELEMENT_REGEX.matcher(computedTypeName);
                if (matcher.find()) {
                    String listElement = matcher.group(1);
                    return mappingContext.getApiReturnListType().replace("{{TYPE}}", listElement);
                }
                throw new IllegalStateException();
            }
            return computedTypeName.replace(SCALA_UTIL_LIST, mappingContext.getApiReturnListType());
        }
        if (Utils.isNotBlank(mappingContext.getApiReturnType())) {
            if (mappingContext.getApiReturnType().contains("{{TYPE}}")) {
                return mappingContext.getApiReturnType().replace("{{TYPE}}", computedTypeName);
            }
            return this.getGenericsString(mappingContext, mappingContext.getApiReturnType(), computedTypeName);
        }
        return this.getTypeConsideringPrimitive(mappingContext, namedDefinition, computedTypeName);
    }

    @Override
    public boolean isPrimitive(String scalaType) {
        return ScalaGraphQLTypeMapper.isScalaPrimitive(scalaType);
    }

    @Override
    public String getGenericsString(MappingContext mappingContext, String genericType, String typeParameter) {
        if (genericType.contains("%s")) {
            return String.format(genericType, typeParameter);
        }
        return String.format("%s[%s]", genericType, typeParameter);
    }

    @Override
    public String wrapApiInputTypeIfRequired(MappingContext mappingContext, NamedDefinition namedDefinition, String parentTypeName) {
        return this.getTypeConsideringPrimitive(mappingContext, namedDefinition, namedDefinition.getJavaName());
    }

    @Override
    public String wrapApiDefaultValueIfRequired(MappingContext mappingContext, NamedDefinition namedDefinition, InputValueDefinition inputValueDefinition, String defaultValue, String parentTypeName) {
        return defaultValue;
    }
}

