/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.generators.impl;

import com.kobylynskyi.graphql.codegen.generators.FilesGenerator;
import com.kobylynskyi.graphql.codegen.generators.FreeMarkerTemplateFilesCreator;
import com.kobylynskyi.graphql.codegen.generators.FreeMarkerTemplateType;
import com.kobylynskyi.graphql.codegen.mapper.DataModelMapperFactory;
import com.kobylynskyi.graphql.codegen.mapper.FieldDefinitionToParameterMapper;
import com.kobylynskyi.graphql.codegen.mapper.FieldDefinitionsToResolverDataModelMapper;
import com.kobylynskyi.graphql.codegen.model.MappingContext;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedDefinition;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedFieldDefinition;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedInterfaceTypeDefinition;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedObjectTypeDefinition;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class FieldResolversGenerator
implements FilesGenerator {
    private final MappingContext mappingContext;
    private final FieldDefinitionsToResolverDataModelMapper fieldDefinitionsToResolverMapper;

    public FieldResolversGenerator(MappingContext mappingContext, DataModelMapperFactory dataModelMapperFactory) {
        this.mappingContext = mappingContext;
        this.fieldDefinitionsToResolverMapper = dataModelMapperFactory.getFieldDefinitionsToResolverMapper();
    }

    @Override
    public List<File> generate() {
        ArrayList<File> generatedFiles = new ArrayList<File>();
        for (ExtendedObjectTypeDefinition extendedObjectTypeDefinition : this.mappingContext.getDocument().getTypeDefinitions()) {
            generatedFiles.addAll(this.generate(extendedObjectTypeDefinition.getFieldDefinitions(), extendedObjectTypeDefinition));
        }
        for (ExtendedInterfaceTypeDefinition extendedInterfaceTypeDefinition : this.mappingContext.getDocument().getInterfaceDefinitions()) {
            generatedFiles.addAll(this.generate(extendedInterfaceTypeDefinition.getFieldDefinitions(), extendedInterfaceTypeDefinition));
        }
        return generatedFiles;
    }

    private List<File> generate(List<ExtendedFieldDefinition> fieldDefinitions, ExtendedDefinition<?, ?> parentDefinition) {
        if (!Boolean.TRUE.equals(this.mappingContext.getGenerateApis())) {
            return Collections.emptyList();
        }
        List<ExtendedFieldDefinition> fieldDefsWithResolvers = fieldDefinitions.stream().filter(fieldDef -> FieldDefinitionToParameterMapper.generateResolversForField(this.mappingContext, fieldDef, parentDefinition)).collect(Collectors.toList());
        ArrayList<File> generatedFiles = new ArrayList<File>();
        if (!fieldDefsWithResolvers.isEmpty()) {
            Map<String, Object> dataModel = this.fieldDefinitionsToResolverMapper.mapToTypeResolver(this.mappingContext, fieldDefsWithResolvers, parentDefinition.getName());
            File file = FreeMarkerTemplateFilesCreator.create(this.mappingContext, FreeMarkerTemplateType.OPERATIONS, dataModel);
            generatedFiles.add(file);
        }
        return generatedFiles;
    }
}

