/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.mapper;

import com.kobylynskyi.graphql.codegen.mapper.AnnotationsMapper;
import com.kobylynskyi.graphql.codegen.mapper.DataModelMapper;
import com.kobylynskyi.graphql.codegen.mapper.GraphQLTypeMapper;
import com.kobylynskyi.graphql.codegen.mapper.MapperFactory;
import com.kobylynskyi.graphql.codegen.model.MappingContext;
import com.kobylynskyi.graphql.codegen.model.NamedDefinition;
import com.kobylynskyi.graphql.codegen.model.ParameterDefinition;
import com.kobylynskyi.graphql.codegen.model.ProjectionParameterDefinition;
import com.kobylynskyi.graphql.codegen.model.builders.DeprecatedDefinitionBuilder;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedDefinition;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedFieldDefinition;
import com.kobylynskyi.graphql.codegen.utils.Utils;
import graphql.language.NamedNode;
import graphql.language.Type;
import java.util.List;
import java.util.stream.Collectors;

public class FieldDefinitionToParameterMapper {
    private final GraphQLTypeMapper graphQLTypeMapper;
    private final DataModelMapper dataModelMapper;
    private final AnnotationsMapper annotationsMapper;

    public FieldDefinitionToParameterMapper(MapperFactory mapperFactory) {
        this.graphQLTypeMapper = mapperFactory.getGraphQLTypeMapper();
        this.dataModelMapper = mapperFactory.getDataModelMapper();
        this.annotationsMapper = mapperFactory.getAnnotationsMapper();
    }

    public static boolean generateResolversForField(MappingContext mappingContext, ExtendedFieldDefinition fieldDef, ExtendedDefinition<?, ?> parentDefinition) {
        String parentTypeName = parentDefinition.getName();
        boolean noResolverForWholeType = mappingContext.getFieldsWithoutResolvers().contains(parentTypeName);
        boolean noResolverForSpecificField = mappingContext.getFieldsWithoutResolvers().contains(parentTypeName + "." + fieldDef.getName());
        if (noResolverForWholeType || noResolverForSpecificField) {
            return false;
        }
        for (String fieldWithoutResolver : mappingContext.getFieldsWithoutResolvers()) {
            boolean noResolverForWholeTypeViaDirective = parentDefinition.getDirectiveNames().stream().anyMatch(fd -> fieldWithoutResolver.equals("@" + fd));
            boolean noResolverForSpecificFieldViaDirective = fieldDef.getDirectives().stream().anyMatch(fd -> fieldWithoutResolver.equals("@" + fd.getName()));
            if (!noResolverForWholeTypeViaDirective && !noResolverForSpecificFieldViaDirective) continue;
            return false;
        }
        boolean resolverForParamField = mappingContext.getGenerateParameterizedFieldsResolvers() != false && !Utils.isEmpty(fieldDef.getInputValueDefinitions());
        boolean resolverForExtendedType = mappingContext.getGenerateExtensionFieldsResolvers() != false && fieldDef.isFromExtension();
        boolean resolverForWholeType = mappingContext.getFieldsWithResolvers().contains(parentTypeName);
        boolean resolverForTypeField = mappingContext.getFieldsWithResolvers().contains(parentTypeName + "." + fieldDef.getName());
        if (resolverForParamField || resolverForExtendedType || resolverForWholeType || resolverForTypeField) {
            return true;
        }
        for (String fieldWithResolver : mappingContext.getFieldsWithResolvers()) {
            boolean resolverForWholeTypeViaDirective = parentDefinition.getDirectiveNames().stream().anyMatch(fd -> fieldWithResolver.equals("@" + fd));
            boolean resolverForSpecificFieldViaDirective = fieldDef.getDirectives().stream().anyMatch(fd -> fieldWithResolver.equals("@" + fd.getName()));
            if (!resolverForWholeTypeViaDirective && !resolverForSpecificFieldViaDirective) continue;
            return true;
        }
        return false;
    }

    public List<ParameterDefinition> mapFields(MappingContext mappingContext, List<ExtendedFieldDefinition> fieldDefinitions, ExtendedDefinition<?, ?> parentDefinition) {
        return fieldDefinitions.stream().filter(fieldDef -> !FieldDefinitionToParameterMapper.generateResolversForField(mappingContext, fieldDef, parentDefinition)).map(fieldDef -> this.mapField(mappingContext, (ExtendedFieldDefinition)((Object)fieldDef), parentDefinition.getName())).collect(Collectors.toList());
    }

    public List<ProjectionParameterDefinition> mapProjectionFields(MappingContext mappingContext, List<ExtendedFieldDefinition> fieldDefinitions, ExtendedDefinition<?, ?> parentTypeDefinition) {
        return fieldDefinitions.stream().map(fieldDef -> this.mapProjectionField(mappingContext, (ExtendedFieldDefinition)((Object)fieldDef), parentTypeDefinition)).collect(Collectors.toList());
    }

    private ParameterDefinition mapField(MappingContext mappingContext, ExtendedFieldDefinition fieldDef, String parentTypeName) {
        NamedDefinition namedDefinition = this.graphQLTypeMapper.getLanguageType(mappingContext, fieldDef.getType(), fieldDef.getName(), parentTypeName);
        ParameterDefinition parameter = new ParameterDefinition();
        parameter.setName(this.dataModelMapper.capitalizeIfRestricted(mappingContext, fieldDef.getName()));
        parameter.setOriginalName(fieldDef.getName());
        parameter.setType(this.graphQLTypeMapper.getTypeConsideringPrimitive(mappingContext, namedDefinition, namedDefinition.getJavaName()));
        parameter.setAnnotations(this.annotationsMapper.getAnnotations(mappingContext, (Type<?>)fieldDef.getType(), (NamedNode<?>)fieldDef, parentTypeName, false));
        parameter.setJavaDoc(fieldDef.getJavaDoc());
        parameter.setDeprecated(DeprecatedDefinitionBuilder.build(mappingContext, fieldDef));
        parameter.setMandatory(namedDefinition.isMandatory());
        parameter.setSerializeUsingObjectMapper(namedDefinition.isSerializeUsingObjectMapper());
        return parameter;
    }

    private ProjectionParameterDefinition mapProjectionField(MappingContext mappingContext, ExtendedFieldDefinition fieldDef, ExtendedDefinition<?, ?> parentTypeDef) {
        ProjectionParameterDefinition parameter = new ProjectionParameterDefinition();
        parameter.setName(fieldDef.getName());
        parameter.setMethodName(this.dataModelMapper.capitalizeMethodNameIfRestricted(mappingContext, parameter.getName()));
        String nestedType = GraphQLTypeMapper.getNestedTypeName(fieldDef.getType());
        if (mappingContext.getTypesUnionsInterfacesNames().contains(nestedType)) {
            parameter.setType(Utils.capitalize(nestedType + mappingContext.getResponseProjectionSuffix()));
        }
        if (!Utils.isEmpty(fieldDef.getInputValueDefinitions())) {
            parameter.setParametrizedInputClassName(DataModelMapper.getParametrizedInputClassName(mappingContext, fieldDef, parentTypeDef));
        }
        parameter.setDeprecated(DeprecatedDefinitionBuilder.build(mappingContext, fieldDef));
        return parameter;
    }
}

