/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.mapper;

import com.kobylynskyi.graphql.codegen.mapper.AnnotationsMapper;
import com.kobylynskyi.graphql.codegen.mapper.DataModelMapper;
import com.kobylynskyi.graphql.codegen.mapper.FieldDefinitionToParameterMapper;
import com.kobylynskyi.graphql.codegen.mapper.GraphQLTypeMapper;
import com.kobylynskyi.graphql.codegen.mapper.MapperFactory;
import com.kobylynskyi.graphql.codegen.model.MappingContext;
import com.kobylynskyi.graphql.codegen.model.builders.JavaDocBuilder;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedInterfaceTypeDefinition;
import graphql.language.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class InterfaceDefinitionToDataModelMapper {
    private final GraphQLTypeMapper graphQLTypeMapper;
    private final AnnotationsMapper annotationsMapper;
    private final DataModelMapper dataModelMapper;
    private final FieldDefinitionToParameterMapper fieldDefinitionToParameterMapper;

    public InterfaceDefinitionToDataModelMapper(MapperFactory mapperFactory, FieldDefinitionToParameterMapper fieldDefinitionToParameterMapper) {
        this.graphQLTypeMapper = mapperFactory.getGraphQLTypeMapper();
        this.annotationsMapper = mapperFactory.getAnnotationsMapper();
        this.dataModelMapper = mapperFactory.getDataModelMapper();
        this.fieldDefinitionToParameterMapper = fieldDefinitionToParameterMapper;
    }

    public Map<String, Object> map(MappingContext mappingContext, ExtendedInterfaceTypeDefinition definition) {
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        dataModel.put("package", DataModelMapper.getModelPackageName(mappingContext));
        dataModel.put("className", this.dataModelMapper.getModelClassNameWithPrefixAndSuffix(mappingContext, definition));
        dataModel.put("javaDoc", JavaDocBuilder.build(definition));
        dataModel.put("implements", this.getInterfaces(mappingContext, definition));
        dataModel.put("annotations", this.annotationsMapper.getAnnotations(mappingContext, definition));
        dataModel.put("fields", this.fieldDefinitionToParameterMapper.mapFields(mappingContext, definition.getFieldDefinitions(), definition));
        dataModel.put("generatedAnnotation", mappingContext.getAddGeneratedAnnotation());
        dataModel.put("generatedInfo", mappingContext.getGeneratedInformation());
        dataModel.put("enumImportItSelfInScala", mappingContext.getEnumImportItSelfInScala());
        dataModel.put("immutableModels", mappingContext.getGenerateImmutableModels());
        dataModel.put("parentInterfaceProperties", mappingContext.getParentInterfaceProperties());
        return dataModel;
    }

    private Set<String> getInterfaces(MappingContext mappingContext, ExtendedInterfaceTypeDefinition definition) {
        return definition.getImplements().stream().map(anImplement -> this.graphQLTypeMapper.getLanguageType(mappingContext, (Type<?>)anImplement)).collect(Collectors.toSet());
    }
}

