/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.mapper;

import com.kobylynskyi.graphql.codegen.mapper.AnnotationsMapper;
import com.kobylynskyi.graphql.codegen.mapper.DataModelMapper;
import com.kobylynskyi.graphql.codegen.mapper.MapperFactory;
import com.kobylynskyi.graphql.codegen.model.MappingContext;
import com.kobylynskyi.graphql.codegen.model.builders.JavaDocBuilder;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedUnionTypeDefinition;
import java.util.HashMap;
import java.util.Map;

public class UnionDefinitionToDataModelMapper {
    private final AnnotationsMapper annotationsMapper;
    private final DataModelMapper dataModelMapper;

    public UnionDefinitionToDataModelMapper(MapperFactory mapperFactory) {
        this.annotationsMapper = mapperFactory.getAnnotationsMapper();
        this.dataModelMapper = mapperFactory.getDataModelMapper();
    }

    public Map<String, Object> map(MappingContext mappingContext, ExtendedUnionTypeDefinition definition) {
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        dataModel.put("package", DataModelMapper.getModelPackageName(mappingContext));
        dataModel.put("className", this.dataModelMapper.getModelClassNameWithPrefixAndSuffix(mappingContext, definition));
        dataModel.put("annotations", this.annotationsMapper.getAnnotations(mappingContext, definition));
        dataModel.put("javaDoc", JavaDocBuilder.build(definition));
        dataModel.put("generatedAnnotation", mappingContext.getAddGeneratedAnnotation());
        dataModel.put("generatedInfo", mappingContext.getGeneratedInformation());
        dataModel.put("enumImportItSelfInScala", mappingContext.getEnumImportItSelfInScala());
        return dataModel;
    }
}

