/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.model.graphql;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.kobylynskyi.graphql.codegen.model.graphql.GraphQLOperation;
import com.kobylynskyi.graphql.codegen.model.graphql.GraphQLOperationRequest;
import com.kobylynskyi.graphql.codegen.model.graphql.GraphQLRequest;
import com.kobylynskyi.graphql.codegen.model.graphql.GraphQLRequests;
import com.kobylynskyi.graphql.codegen.model.graphql.UnableToBuildJsonQueryException;
import com.kobylynskyi.graphql.codegen.utils.Utils;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;

public class GraphQLRequestSerializer {
    public static final ObjectMapper OBJECT_MAPPER = Utils.OBJECT_MAPPER;

    private GraphQLRequestSerializer() {
    }

    public static String toHttpJsonBody(GraphQLRequests graphQLRequests) {
        if (graphQLRequests.getRequests().isEmpty()) {
            throw new IllegalArgumentException("At least one GraphQL request should be supplied");
        }
        GraphQLOperationRequest firstRequest = graphQLRequests.getRequests().get(0).getRequest();
        StringBuilder queryBuilder = new StringBuilder();
        for (GraphQLRequest request : graphQLRequests.getRequests()) {
            if (request == null || request.getRequest() == null) {
                throw new IllegalArgumentException("Null GraphQL request was supplied");
            }
            if (firstRequest.getOperationType() != null && firstRequest.getOperationType() != request.getRequest().getOperationType()) {
                throw new IllegalArgumentException("Only operations of the same type (query/mutation/subscription) can be executed at once");
            }
            queryBuilder.append(GraphQLRequestSerializer.buildQuery(request)).append(" ");
        }
        return GraphQLRequestSerializer.jsonQuery(GraphQLRequestSerializer.operationWrapper(firstRequest.getOperationType(), graphQLRequests.getOperationName(), queryBuilder.toString()));
    }

    public static String toHttpJsonBody(GraphQLRequest graphQLRequest) {
        if (graphQLRequest == null || graphQLRequest.getRequest() == null) {
            return null;
        }
        return GraphQLRequestSerializer.jsonQuery(GraphQLRequestSerializer.toQueryString(graphQLRequest));
    }

    public static String toQueryString(GraphQLRequest graphQLRequest) {
        if (graphQLRequest == null || graphQLRequest.getRequest() == null) {
            return null;
        }
        String operationName = graphQLRequest.getOperationName() == null ? graphQLRequest.getRequest().getOperationName() : graphQLRequest.getOperationName();
        return GraphQLRequestSerializer.operationWrapper(graphQLRequest.getRequest().getOperationType(), operationName, GraphQLRequestSerializer.buildQuery(graphQLRequest));
    }

    private static String operationWrapper(GraphQLOperation operationType, String operationName, String queryValue) {
        assert (operationType != null);
        String operationTypeLowerCased = operationType.name().toLowerCase();
        if (operationName == null) {
            return String.format("%s { %s }", operationTypeLowerCased, queryValue);
        }
        return String.format("%s %s { %s }", operationTypeLowerCased, operationName, queryValue);
    }

    private static String buildQuery(GraphQLRequest graphQLRequest) {
        StringBuilder builder = new StringBuilder();
        GraphQLOperationRequest request = graphQLRequest.getRequest();
        if (request.getAlias() != null) {
            builder.append(request.getAlias()).append(": ");
        }
        builder.append(request.getOperationName());
        Map<String, Object> input = request.getInput();
        Set<String> useObjectMapperForInputSerialization = request.getUseObjectMapperForInputSerialization();
        if (GraphQLRequestSerializer.requestHasInput(input)) {
            builder.append("(");
            Iterator<Map.Entry<String, Object>> inputEntryIterator = input.entrySet().iterator();
            boolean valueAdded = false;
            while (inputEntryIterator.hasNext()) {
                Map.Entry<String, Object> inputEntry = inputEntryIterator.next();
                if (inputEntry.getValue() == null) continue;
                if (valueAdded) {
                    builder.append(", ");
                }
                builder.append(inputEntry.getKey());
                builder.append(": ");
                boolean useObjectMapper = useObjectMapperForInputSerialization.contains(inputEntry.getKey());
                builder.append(GraphQLRequestSerializer.getEntry(inputEntry.getValue(), useObjectMapper));
                valueAdded = true;
            }
            builder.append(")");
        }
        if (graphQLRequest.getResponseProjection() != null) {
            builder.append(graphQLRequest.getResponseProjection().toString());
        }
        return builder.toString();
    }

    private static boolean requestHasInput(Map<String, Object> input) {
        return input != null && !input.isEmpty() && input.values().stream().anyMatch(Objects::nonNull);
    }

    private static String jsonQuery(String queryString) {
        ObjectNode objectNode = Utils.OBJECT_MAPPER.createObjectNode();
        objectNode.put("query", queryString);
        return GraphQLRequestSerializer.objectMapperWriteValueAsString(objectNode);
    }

    public static String getEntry(Object input) {
        return GraphQLRequestSerializer.getEntry(input, false);
    }

    public static String getEntry(Object input, boolean useObjectMapper) {
        if (input == null) {
            return null;
        }
        if (useObjectMapper) {
            return GraphQLRequestSerializer.objectMapperWriteValueAsString(input);
        }
        if (input instanceof Collection) {
            return GraphQLRequestSerializer.serializeCollection((Collection)input, useObjectMapper);
        }
        if (input instanceof Map) {
            return GraphQLRequestSerializer.serializeMap((Map)input, useObjectMapper);
        }
        if (input instanceof Map.Entry) {
            return GraphQLRequestSerializer.serializeMapEntry((Map.Entry)input, useObjectMapper);
        }
        if (input instanceof Enum) {
            return GraphQLRequestSerializer.serializeEnum((Enum)input);
        }
        if (input instanceof String) {
            return GraphQLRequestSerializer.escapeJsonString(input.toString());
        }
        if (input.getClass().getName().equals("scala.Some")) {
            return input.toString().replace("Some(", "").replace(")", "");
        }
        if (input.getClass().getName().equals("scala.None$")) {
            return null;
        }
        return input.toString();
    }

    public static String serializeCollection(Collection<?> input, boolean useObjectMapper) {
        StringJoiner joiner = new StringJoiner(", ", "[ ", " ]");
        for (Object entry : input) {
            joiner.add(GraphQLRequestSerializer.getEntry(entry, useObjectMapper));
        }
        return joiner.toString();
    }

    public static String serializeMap(Map<?, ?> input, boolean useObjectMapper) {
        StringJoiner joiner = new StringJoiner(", ", "{ ", " }");
        for (Map.Entry<?, ?> entry : input.entrySet()) {
            joiner.add(GraphQLRequestSerializer.getEntry(entry, useObjectMapper));
        }
        return joiner.toString();
    }

    public static String serializeMapEntry(Map.Entry<?, ?> input, boolean useObjectMapper) {
        return input.getKey() + ": " + GraphQLRequestSerializer.getEntry(input.getValue(), useObjectMapper);
    }

    public static String serializeEnum(Enum<?> input) {
        return input.toString();
    }

    public static String escapeJsonString(String stringValue) {
        int len = stringValue.length();
        StringBuilder sb = new StringBuilder(len + 2);
        sb.append("\"");
        block9: for (int i = 0; i < len; ++i) {
            char ch = stringValue.charAt(i);
            switch (ch) {
                case '\"': {
                    sb.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        sb.append("\"");
        return sb.toString();
    }

    public static String objectMapperWriteValueAsString(Object input) {
        try {
            return OBJECT_MAPPER.writeValueAsString(input);
        }
        catch (JsonProcessingException e) {
            throw new UnableToBuildJsonQueryException((Exception)((Object)e));
        }
    }
}

