/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.mapper;

import com.kobylynskyi.graphql.codegen.mapper.DataModelMapper;
import com.kobylynskyi.graphql.codegen.mapper.GraphQLTypeMapper;
import com.kobylynskyi.graphql.codegen.mapper.ValueMapper;
import com.kobylynskyi.graphql.codegen.model.MappingContext;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedDefinition;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedFieldDefinition;
import com.kobylynskyi.graphql.codegen.utils.Utils;
import graphql.language.Argument;
import graphql.language.Directive;
import graphql.language.InputValueDefinition;
import graphql.language.ListType;
import graphql.language.NamedNode;
import graphql.language.NonNullType;
import graphql.language.Type;
import graphql.language.TypeName;
import graphql.language.UnionTypeDefinition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class AnnotationsMapper {
    public List<String> getAnnotations(MappingContext mappingContext, Type<?> type, NamedNode<?> def, String parentTypeName, boolean mandatory) {
        if (type instanceof ListType) {
            Type subType = ((ListType)type).getType();
            return this.getAnnotations(mappingContext, subType, def, parentTypeName, mandatory);
        }
        if (type instanceof NonNullType) {
            Type parentType = null;
            if (def instanceof ExtendedFieldDefinition) {
                parentType = ((ExtendedFieldDefinition)def).getType();
            } else if (def instanceof InputValueDefinition) {
                parentType = ((InputValueDefinition)def).getType();
            }
            if (!(parentType instanceof ListType)) {
                mandatory = true;
            }
            return this.getAnnotations(mappingContext, ((NonNullType)type).getType(), def, parentTypeName, mandatory);
        }
        if (type instanceof TypeName) {
            return this.getAnnotations(mappingContext, ((TypeName)type).getName(), def.getName(), parentTypeName, GraphQLTypeMapper.getDirectives(def), mandatory, def);
        }
        return Collections.emptyList();
    }

    public List<String> getAnnotations(MappingContext mappingContext, ExtendedDefinition<?, ?> extendedDefinition) {
        if (extendedDefinition == null) {
            return Collections.emptyList();
        }
        Object def = extendedDefinition.getDefinition();
        return this.getAnnotations(mappingContext, extendedDefinition.getName(), extendedDefinition.getName(), null, extendedDefinition.getDirectives(), false, (NamedNode<?>)def);
    }

    public List<String> getAnnotations(MappingContext mappingContext, String name) {
        return this.getAnnotations(mappingContext, name, name, null, Collections.emptyList(), false, null);
    }

    public List<String> getAnnotations(MappingContext mappingContext, String graphQLTypeName, String name, String parentTypeName, List<Directive> directives, boolean mandatory, NamedNode<?> def) {
        String modelValidationAnnotation;
        ArrayList<String> annotations = new ArrayList<String>();
        if (mandatory && (modelValidationAnnotation = this.getModelValidationAnnotation(mappingContext, graphQLTypeName)) != null) {
            annotations.add(modelValidationAnnotation);
        }
        annotations.addAll(AnnotationsMapper.getTypeAnnotationsForKey(mappingContext, parentTypeName + "." + name));
        annotations.addAll(AnnotationsMapper.getTypeAnnotationsForKey(mappingContext, graphQLTypeName));
        annotations.addAll(this.getJacksonTypeIdAnnotations(mappingContext, def));
        if (def instanceof ExtendedFieldDefinition) {
            annotations.addAll(this.getAdditionalAnnotations(mappingContext, graphQLTypeName));
        }
        Map<String, List<String>> directiveAnnotationsMapping = mappingContext.getDirectiveAnnotationsMapping();
        for (Directive directive : directives) {
            List<String> directiveAnnotations = directiveAnnotationsMapping.get(directive.getName());
            if (Utils.isEmpty(directiveAnnotations)) continue;
            annotations.addAll(this.getAnnotationsForDirective(mappingContext, directiveAnnotations, directive));
        }
        return annotations;
    }

    private static List<String> getTypeAnnotationsForKey(MappingContext mappingContext, String key) {
        ArrayList<String> result = new ArrayList<String>();
        Map<String, List<String>> customAnnotationsMapping = mappingContext.getCustomAnnotationsMapping();
        List<String> typeAnnotations = customAnnotationsMapping.get(key);
        if (!Utils.isEmpty(typeAnnotations)) {
            result.addAll(typeAnnotations);
        } else {
            for (Map.Entry<String, List<String>> entry : customAnnotationsMapping.entrySet()) {
                if (!key.matches(entry.getKey()) || Utils.isEmpty((Collection)entry.getValue())) continue;
                result.addAll((Collection<String>)entry.getValue());
            }
        }
        return result;
    }

    private String getModelValidationAnnotation(MappingContext mappingContext, String graphQLTypeName) {
        String possiblyPrimitiveType = mappingContext.getCustomTypesMapping().get(GraphQLTypeMapper.getMandatoryType(graphQLTypeName));
        String modelValidationAnnotation = mappingContext.getModelValidationAnnotation();
        if (Utils.isNotBlank(modelValidationAnnotation) && this.addModelValidationAnnotationForType(possiblyPrimitiveType)) {
            return modelValidationAnnotation;
        }
        return null;
    }

    public List<String> getAnnotationsForDirective(MappingContext mappingContext, List<String> directiveAnnotations, Directive directive) {
        ArrayList<String> directiveAnnotationsMapped = new ArrayList<String>();
        Iterator<String> iterator = directiveAnnotations.iterator();
        while (iterator.hasNext()) {
            String annotation;
            String directiveAnnotationMapped = annotation = iterator.next();
            for (Argument dirArg : directive.getArguments()) {
                String argumentValueFormatter = Utils.substringBetween(annotation, "{{" + dirArg.getName(), "}}");
                if (argumentValueFormatter == null) continue;
                String replace = String.format("{{%s%s}}", dirArg.getName(), argumentValueFormatter);
                String replaceWith = this.getValueMapper().map(mappingContext, dirArg.getValue(), null, argumentValueFormatter);
                directiveAnnotationMapped = directiveAnnotationMapped.replace(replace, replaceWith);
            }
            directiveAnnotationsMapped.add(directiveAnnotationMapped);
        }
        return directiveAnnotationsMapped;
    }

    public List<String> getJacksonTypeIdAnnotations(MappingContext mappingContext, NamedNode<?> def) {
        ArrayList<String> defaults = new ArrayList<String>();
        if (Boolean.TRUE.equals(mappingContext.getGenerateJacksonTypeIdResolver()) && def instanceof UnionTypeDefinition) {
            defaults.add("com.fasterxml.jackson.annotation.JsonTypeInfo(use = com.fasterxml.jackson.annotation.JsonTypeInfo.Id.NAME, property = \"__typename\")");
            String modelPackageName = DataModelMapper.getModelPackageName(mappingContext);
            if (modelPackageName == null) {
                modelPackageName = "";
            } else if (Utils.isNotBlank(modelPackageName)) {
                modelPackageName = modelPackageName + ".";
            }
            defaults.add(this.getJacksonResolverTypeIdAnnotation(modelPackageName));
        }
        return defaults;
    }

    public abstract String getJacksonResolverTypeIdAnnotation(String var1);

    protected abstract List<String> getAdditionalAnnotations(MappingContext var1, String var2);

    public abstract boolean addModelValidationAnnotationForType(String var1);

    public abstract ValueMapper getValueMapper();
}

