/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.kotlin;

import com.kobylynskyi.graphql.codegen.mapper.DataModelMapper;
import com.kobylynskyi.graphql.codegen.mapper.GraphQLTypeMapper;
import com.kobylynskyi.graphql.codegen.model.MappingContext;
import com.kobylynskyi.graphql.codegen.model.NamedDefinition;
import com.kobylynskyi.graphql.codegen.model.graphql.GraphQLOperation;
import com.kobylynskyi.graphql.codegen.utils.Utils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class KotlinGraphQLTypeMapper
extends GraphQLTypeMapper {
    private static final String KOTLIN_UTIL_LIST = "List";
    private static final String KOTLIN_UTIL_NULLABLE = "?";
    private static final Set<String> KOTLIN_PRIMITIVE_TYPES = new HashSet<String>(Arrays.asList("Byte", "Short", "Int", "Long", "Float", "Double", "Char", "Boolean"));

    public static boolean isKotlinPrimitive(String scalaType) {
        return KOTLIN_PRIMITIVE_TYPES.contains(scalaType);
    }

    public static String defaultValueKotlinPrimitive(String kotlinType) {
        switch (kotlinType) {
            case "Long": {
                return "0L";
            }
            case "Float": {
                return "0F";
            }
            case "Double": {
                return "0.0";
            }
            case "Char": {
                return "0.toChar()";
            }
            case "Boolean": {
                return "false";
            }
        }
        return "0";
    }

    @Override
    public String wrapIntoList(MappingContext mappingContext, String type, boolean mandatory) {
        if (!mandatory) {
            return this.getGenericsString(mappingContext, KOTLIN_UTIL_LIST, type) + KOTLIN_UTIL_NULLABLE;
        }
        return this.getGenericsString(mappingContext, KOTLIN_UTIL_LIST, type);
    }

    @Override
    public String wrapSuperTypeIntoList(MappingContext mappingContext, String type, boolean mandatory) {
        if (!mandatory) {
            return this.getGenericsString(mappingContext, KOTLIN_UTIL_LIST, "out " + type) + KOTLIN_UTIL_NULLABLE;
        }
        return this.getGenericsString(mappingContext, KOTLIN_UTIL_LIST, "out " + type);
    }

    @Override
    public String wrapApiReturnTypeIfRequired(MappingContext mappingContext, NamedDefinition namedDefinition, String parentTypeName) {
        String computedTypeName = namedDefinition.getJavaName();
        if (parentTypeName.equalsIgnoreCase(GraphQLOperation.SUBSCRIPTION.name()) && Utils.isNotBlank(mappingContext.getSubscriptionReturnType())) {
            return this.getGenericsString(mappingContext, mappingContext.getSubscriptionReturnType(), computedTypeName);
        }
        if (computedTypeName.startsWith(KOTLIN_UTIL_LIST) && Utils.isNotBlank(mappingContext.getApiReturnListType())) {
            return computedTypeName.replace(KOTLIN_UTIL_LIST, mappingContext.getApiReturnListType());
        }
        if (Utils.isNotBlank(mappingContext.getApiReturnType())) {
            return this.getGenericsString(mappingContext, mappingContext.getApiReturnType(), computedTypeName);
        }
        return this.getTypeConsideringPrimitive(mappingContext, namedDefinition, computedTypeName);
    }

    @Override
    public boolean isPrimitive(String kotlinType) {
        return KotlinGraphQLTypeMapper.isKotlinPrimitive(kotlinType);
    }

    @Override
    public String getTypeConsideringPrimitive(MappingContext mappingContext, NamedDefinition namedDefinition, String computedTypeName) {
        String possiblyPrimitiveType;
        String graphqlTypeName = namedDefinition.getGraphqlTypeName();
        if (namedDefinition.isMandatory() && namedDefinition.isPrimitiveCanBeUsed() && this.isPrimitive(possiblyPrimitiveType = mappingContext.getCustomTypesMapping().get(GraphQLTypeMapper.getMandatoryType(graphqlTypeName)))) {
            return possiblyPrimitiveType;
        }
        if (!namedDefinition.isMandatory()) {
            if (!computedTypeName.endsWith(KOTLIN_UTIL_NULLABLE) && !computedTypeName.startsWith(KOTLIN_UTIL_LIST)) {
                return computedTypeName + KOTLIN_UTIL_NULLABLE;
            }
            if (computedTypeName.startsWith(KOTLIN_UTIL_LIST) && !graphqlTypeName.endsWith(KOTLIN_UTIL_NULLABLE)) {
                String modelClassNameWithPrefixAndSuffix = DataModelMapper.getModelClassNameWithPrefixAndSuffix(mappingContext, graphqlTypeName);
                if (computedTypeName.contains(modelClassNameWithPrefixAndSuffix + KOTLIN_UTIL_NULLABLE) || computedTypeName.contains(graphqlTypeName + KOTLIN_UTIL_NULLABLE)) {
                    return computedTypeName;
                }
                if (!computedTypeName.contains(modelClassNameWithPrefixAndSuffix + KOTLIN_UTIL_NULLABLE) && computedTypeName.contains(modelClassNameWithPrefixAndSuffix)) {
                    return computedTypeName.replace(modelClassNameWithPrefixAndSuffix, modelClassNameWithPrefixAndSuffix + KOTLIN_UTIL_NULLABLE);
                }
                if (!computedTypeName.contains(graphqlTypeName + KOTLIN_UTIL_NULLABLE) && computedTypeName.contains(graphqlTypeName)) {
                    return computedTypeName.replace(graphqlTypeName, graphqlTypeName + KOTLIN_UTIL_NULLABLE);
                }
            }
        }
        return computedTypeName;
    }

    @Override
    public String getResponseReturnType(MappingContext mappingContext, NamedDefinition namedDefinition, String computedTypeName) {
        return this.getTypeConsideringPrimitive(mappingContext, namedDefinition, computedTypeName);
    }
}

