/*
 * Decompiled with CFR 0.152.
 */
package com.kobylynskyi.graphql.codegen.model.definitions;

import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedDefinition;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedEnumTypeDefinition;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedInputObjectTypeDefinition;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedInterfaceTypeDefinition;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedObjectTypeDefinition;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedScalarTypeDefinition;
import com.kobylynskyi.graphql.codegen.model.definitions.ExtendedUnionTypeDefinition;
import graphql.language.FieldDefinition;
import graphql.language.Type;
import graphql.language.TypeName;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ExtendedDocument {
    private final Collection<ExtendedObjectTypeDefinition> operationDefinitions;
    private final Collection<ExtendedObjectTypeDefinition> typeDefinitions;
    private final Collection<ExtendedInputObjectTypeDefinition> inputDefinitions;
    private final Collection<ExtendedEnumTypeDefinition> enumDefinitions;
    private final Collection<ExtendedScalarTypeDefinition> scalarDefinitions;
    private final Collection<ExtendedInterfaceTypeDefinition> interfaceDefinitions;
    private final Collection<ExtendedUnionTypeDefinition> unionDefinitions;

    public ExtendedDocument(Collection<ExtendedObjectTypeDefinition> operationDefinitions, Collection<ExtendedObjectTypeDefinition> typeDefinitions, Collection<ExtendedInputObjectTypeDefinition> inputDefinitions, Collection<ExtendedEnumTypeDefinition> enumDefinitions, Collection<ExtendedScalarTypeDefinition> scalarDefinitions, Collection<ExtendedInterfaceTypeDefinition> interfaceDefinitions, Collection<ExtendedUnionTypeDefinition> unionDefinitions) {
        this.operationDefinitions = operationDefinitions;
        this.typeDefinitions = typeDefinitions;
        this.inputDefinitions = inputDefinitions;
        this.enumDefinitions = enumDefinitions;
        this.scalarDefinitions = scalarDefinitions;
        this.interfaceDefinitions = interfaceDefinitions;
        this.unionDefinitions = unionDefinitions;
    }

    public Set<String> getTypesUnionsInterfacesNames() {
        LinkedHashSet<String> typesUnionsInterfaces = new LinkedHashSet<String>();
        this.typeDefinitions.stream().map(ExtendedDefinition::getName).forEach(typesUnionsInterfaces::add);
        this.unionDefinitions.stream().map(ExtendedDefinition::getName).forEach(typesUnionsInterfaces::add);
        this.interfaceDefinitions.stream().map(ExtendedDefinition::getName).forEach(typesUnionsInterfaces::add);
        return typesUnionsInterfaces;
    }

    public Map<String, Set<String>> getInterfaceChildren() {
        HashMap<String, Set<String>> interfaceChildren = new HashMap<String, Set<String>>();
        for (ExtendedObjectTypeDefinition typeDefinition : this.typeDefinitions) {
            for (Type interfaceType : typeDefinition.getImplements()) {
                interfaceChildren.computeIfAbsent(((TypeName)interfaceType).getName(), k -> new HashSet()).add(typeDefinition.getName());
            }
        }
        for (ExtendedInterfaceTypeDefinition interfaceTypeDefinition : this.interfaceDefinitions) {
            for (Type interfaceType : interfaceTypeDefinition.getImplements()) {
                interfaceChildren.computeIfAbsent(((TypeName)interfaceType).getName(), k -> new HashSet()).add(interfaceTypeDefinition.getName());
            }
        }
        return interfaceChildren;
    }

    public Set<String> getInterfacesNames() {
        return this.interfaceDefinitions.stream().map(ExtendedDefinition::getName).collect(Collectors.toSet());
    }

    public Set<String> getOperationsNames() {
        return this.operationDefinitions.stream().map(ExtendedObjectTypeDefinition::getFieldDefinitions).flatMap(Collection::stream).map(FieldDefinition::getName).collect(Collectors.toSet());
    }

    public Collection<ExtendedObjectTypeDefinition> getOperationDefinitions() {
        return this.operationDefinitions;
    }

    public Collection<ExtendedObjectTypeDefinition> getTypeDefinitions() {
        return this.typeDefinitions;
    }

    public Collection<ExtendedInputObjectTypeDefinition> getInputDefinitions() {
        return this.inputDefinitions;
    }

    public Collection<ExtendedEnumTypeDefinition> getEnumDefinitions() {
        return this.enumDefinitions;
    }

    public Collection<ExtendedScalarTypeDefinition> getScalarDefinitions() {
        return this.scalarDefinitions;
    }

    public Collection<ExtendedInterfaceTypeDefinition> getInterfaceDefinitions() {
        return this.interfaceDefinitions;
    }

    public Collection<ExtendedUnionTypeDefinition> getUnionDefinitions() {
        return this.unionDefinitions;
    }
}

