package io.github.kosmx.bendylib;

import io.github.kosmx.bendylib.impl.BendableCuboid;
import io.github.kosmx.bendylib.impl.ICuboid;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import javax.annotation.Nullable;
import net.minecraft.class_2350;
import net.minecraft.class_3879;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_630;

/**
 * You can use this to swap a ModelPart to something else.
 * {@link IModelPart#mutate(MutableModelPart)} to do that
 * ((IModelPart)yourModelPart).mutate(yourMutatedModelPart) will do the trick
 *
 * {@link IModelPart#removeMutate(MutableModelPart)} to remove
 * You can use is as the default modelPart in a model.
 * This can be used with {@link ICuboid}.
 */
public abstract class MutableModelPart extends class_630 {

    @Nullable
    @Deprecated
    private MutableModelPart last = null;

    protected final ObjectList<ICuboid> iCuboids = new ObjectArrayList<>();
    public MutableModelPart(class_3879 model) {
        super(model);
    }

    public MutableModelPart(class_3879 model, int textureOffsetU, int textureOffsetV) {
        super(model, textureOffsetU, textureOffsetV);
    }

    public MutableModelPart(int textureWidth, int textureHeight, int textureOffsetU, int textureOffsetV) {
        super(textureWidth, textureHeight, textureOffsetU, textureOffsetV);
    }

    public MutableModelPart(class_630 modelPart){
        this((int)modelPart.field_3659, (int)modelPart.field_3658, modelPart.field_3672, modelPart.field_3670);
    }

    /*
    @Override
    public Cuboid getRandomCuboid(Random random) {
        if(this.cuboids.size() != 0) return super.getRandomCuboid(random);
        else return new Cuboid()
    }

     *///TODO don't cause crash



    @Override
    public void method_22699(class_4587 matrices, class_4588 vertices, int light, int overlay, float red, float green, float blue, float alpha) {
        super.method_22699(matrices, vertices, light, overlay, red, green, blue, alpha);
        if(!iCuboids.isEmpty()){
            matrices.method_22903();
            this.method_22703(matrices);
            this.renderICuboids(matrices.method_23760(), vertices, light, overlay, red, green, blue, alpha);
            matrices.method_22909();
        }
    }

    protected void renderICuboids(class_4587.class_4665 matrices, class_4588 vertexConsumer, int light, int overlay, float red, float green, float blue, float alpha) {
        this.iCuboids.forEach((cuboid)-> cuboid.render(matrices, vertexConsumer, red, green, blue, alpha, light, overlay));
    }

    public void addICuboid(ICuboid cuboid){
        this.iCuboids.add(cuboid);
    }

    /**
     * For Cross-mod compatibility
     * @return the Priority level. If there is a lower level, that will be applied
     * Mods like Mo'bends should use higher e.g. 5
     * Mods like Emotecraft should use lover e.g. 1
     */
    public int getPriority(){
        return 2;
    }

    public boolean isActive(){
        return true;
    }

    /**
     * incompatibility finder tool
     * @return the mod's name or id
     */
    public abstract String modId();


    //The Bendable cuboid generator code
    public BendableCuboid createCuboid(int x, int y, int z, int sizeX, int sizeY, int sizeZ, float extraX, float extraY, float extraZ, class_2350 direction){
        BendableCuboid.Builder builder = new BendableCuboid.Builder();
        builder.x = x;
        builder.y = y;
        builder.z = z;
        builder.sizeX = sizeX;
        builder.sizeY = sizeY;
        builder.sizeZ = sizeZ;
        builder.extraX = extraX;
        builder.extraY = extraY;
        builder.extraZ = extraZ;
        builder.direction = direction;
        builder.textureWidth = (int) this.field_3659;
        builder.textureHeight = (int) this.field_3658;
        builder.u = field_3672;
        builder.v = field_3670;
        return builder.build();
    }
    public MutableModelPart addCuboid(int x, int y, int z, int sizeX, int sizeY, int sizeZ, float extraX, float extraY, float extraZ, class_2350 direction){
        this.iCuboids.add(this.createCuboid(x, y, z, sizeX, sizeY, sizeZ, extraX, extraY, extraZ, direction));
        return this;
    }

    public BendableCuboid createCuboid(int x, int y, int z, int sizeX, int sizeY, int sizeZ, float extra, class_2350 direction){
        return this.createCuboid(x, y, z, sizeX, sizeY, sizeZ, extra, extra, extra, direction);
    }
    public MutableModelPart addCuboid(int x, int y, int z, int sizeX, int sizeY, int sizeZ, float extra, class_2350 direction){
        return this.addCuboid(x, y, z, sizeX, sizeY, sizeZ, extra, extra, extra, direction);
    }
}
