package io.github.kosmx.bendylib.impl;

import net.minecraft.class_4587;
import net.minecraft.class_4588;

/**
 * Minecraft Cuboid object
 * define it as you wish, render it as you wish!
 * You can use {@link BendableCuboid} to bend parts.
 */
public interface ICuboid {

    /**
     * See {@link BendableCuboid#render(class_4587.class_4665, class_4588, float, float, float, float, int, int)} how to do it
     * Or you can check the original MC code {@link net.minecraft.class_630#method_22699(class_4587, class_4588, int, int, float, float, float, float)}
     *
     * @param matrices Minecraft's Matrix transformation
     * @param vertexConsumer Minecraft Vertex consumer, add vertices to render
     * @param red red
     * @param green green
     * @param blue blue
     * @param alpha alpha
     * @param light light
     * @param overlay overlay
     */
    void render(class_4587.class_4665 matrices, class_4588 vertexConsumer, float red, float green, float blue, float alpha, int light, int overlay);
}
