package io.github.kosmx.bendylib.impl.math;

import net.minecraft.class_1159;
import net.minecraft.class_1160;

public class Matrix4 extends class_1159 {

    public Matrix4(Matrix4 matrix4) {
        super(matrix4);
    }

    public Matrix4(){}

    /**
     *
     * create a matrix from eigenvectors.
     * vectors can have any non-zero length, the eigenvalues will scale.
     *
     *
     * @param vec1 1st Eigenvector
     * @param vec2 2nd Eigenvector
     * @param vec3 3rd Eigenvector
     * @param val1 1st vector's Eigenvalue
     * @param val2 2nd vector's Eigenvalue
     * @param val3 3rd vector's Eigenvalue
     * The identity eigenvalues are 1! (does not make change)
     */
    public void fromEigenVector(class_1160 vec1, class_1160 vec2, class_1160 vec3, float val1, float val2, float val3){
        this.field_21652 = vec1.method_4943();
        this.field_21656 = vec1.method_4945();
        this.field_21660 = vec1.method_4947();
        this.field_21664 = 0;
        this.field_21653 = vec2.method_4943();
        this.field_21657 = vec2.method_4945();
        this.field_21661 = vec2.method_4947();
        this.field_21665 = 0;
        this.field_21654 = vec3.method_4943();
        this.field_21658 = vec3.method_4945();
        this.field_21662 = vec3.method_4947();
        this.field_21666 = 0;
        this.field_21655 = 0;
        this.field_21659 = 0;
        this.field_21663 = 0;
        this.field_21667 = 1;

        class_1159 matrix4f = this.method_22673();

        /*
            Minecraft matrix multiplication:
            A.multiply(B) equals with A*B
         */

        class_1159 inverse = new Matrix4(this);
        inverse.method_22870();

        this.method_22672(class_1159.method_24019(val1, val2, val3));
        this.method_22672(inverse);
    }

    /**
     *
     * create a matrix from eigenvectors.
     * The eigen values are the length of the vectors
     * (just to make things easier)
     *
     * @param vec1 1st Eigenvector
     * @param vec2 2nd Eigenvector
     * @param vec3 3rd Eigenvector
     */
    public void fromEigenVector(class_1160 vec1, class_1160 vec2, class_1160 vec3){
        fromEigenVector(vec1, vec2, vec3, length(vec1), length(vec2), length(vec3));
    }

    /*
    public static float length(Vector4f vector4f){
        return Math.rt(vector4f.getX() * vector4f.getX() + vector4f.getY() * vector4f.getY() + vector4f.getZ() * vector4f.getZ() + vector4f.getW() * vector4f.getW();
    }

     */
    public static float length(class_1160 vector4f){
        return (float) Math.sqrt(vector4f.method_4943() * vector4f.method_4943() + vector4f.method_4945() * vector4f.method_4945() + vector4f.method_4947() * vector4f.method_4947());
    }

}
