/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.bendylib.impl;

import io.github.kosmx.bendylib.impl.IterableRePos;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1162;
import net.minecraft.class_2350;
import net.minecraft.class_4581;

public interface IBendable {
    default public class_1159 applyBend(float bendAxis, float bendValue, IterableRePos posSupplier) {
        class_1160 axis = new class_1160((float)Math.cos(bendAxis), 0.0f, (float)Math.sin(bendAxis));
        class_4581 matrix3f = new class_4581(this.getBendDirection().method_23224());
        axis.method_23215(matrix3f);
        class_1159 transformMatrix = new class_1159();
        transformMatrix.method_22668();
        transformMatrix.method_22672(class_1159.method_24021((float)this.getBendX(), (float)this.getBendY(), (float)this.getBendZ()));
        transformMatrix.method_22670(axis.method_23626(bendValue));
        transformMatrix.method_22672(class_1159.method_24021((float)(-this.getBendX()), (float)(-this.getBendY()), (float)(-this.getBendZ())));
        Plane basePlane = this.getBasePlane();
        Plane otherPlane = this.getOtherSidePlane();
        class_1160 directionUnit = this.getBendDirection().method_23955();
        directionUnit.method_4951(axis);
        Plane bendPlane = new Plane(directionUnit, new class_1160(this.getBendX(), this.getBendY(), this.getBendZ()));
        float halfSize = this.bendHeight() / 2.0f;
        boolean bl = this.getBendDirection() == class_2350.field_11036 || this.getBendDirection() == class_2350.field_11035 || this.getBendDirection() == class_2350.field_11034;
        posSupplier.iteratePositions(iPosWithOrigin -> {
            class_1160 newPos = iPosWithOrigin.getOriginalPos();
            float distFromBend = bl ? -bendPlane.distanceTo(newPos) : bendPlane.distanceTo(newPos);
            float distFromBase = basePlane.distanceTo(newPos);
            float distFromOther = otherPlane.distanceTo(newPos);
            double s = Math.tan(bendValue / 2.0f) * (double)distFromBend;
            class_1160 x = this.getBendDirection().method_23955();
            if (Math.abs(distFromBase) < Math.abs(distFromOther)) {
                x.method_4942((float)((double)(-distFromBase / halfSize) * s));
                newPos.method_23846(x);
                class_1162 reposVector = new class_1162(newPos);
                reposVector.method_22674(transformMatrix);
                newPos = new class_1160(reposVector.method_4953(), reposVector.method_4956(), reposVector.method_4957());
            } else {
                x.method_4942((float)((double)(-distFromOther / halfSize) * s));
                newPos.method_23846(x);
            }
            iPosWithOrigin.setPos(newPos);
        });
        return transformMatrix;
    }

    public class_2350 getBendDirection();

    public float getBendX();

    public float getBendY();

    public float getBendZ();

    public Plane getBasePlane();

    public Plane getOtherSidePlane();

    default public float bendHeight() {
        return this.getBasePlane().distanceTo(this.getOtherSidePlane());
    }

    public static class Plane {
        final class_1160 normal;
        final float normDistance;

        public Plane(class_1160 normal, class_1160 position) {
            this.normal = normal.method_23850();
            this.normal.method_4952();
            this.normDistance = -normal.method_4950(position);
        }

        public float distanceTo(class_1160 pos) {
            return this.normal.method_4950(pos) + this.normDistance;
        }

        public float distanceTo(Plane otherPlane) {
            class_1160 tmp = this.normal.method_23850();
            tmp.method_4951(otherPlane.normal);
            if ((double)tmp.method_4950(tmp) < 0.01) {
                return this.normDistance + this.normal.method_4950(otherPlane.normal) * otherPlane.normDistance;
            }
            return 0.0f;
        }
    }
}

