package io.github.kosmx.bendylib;

import io.github.kosmx.bendylib.impl.DummyCuboid;
import io.github.kosmx.bendylib.impl.accessors.IModelPartAccessor;
import java.util.*;
import net.minecraft.class_630;

/**
 * Access to children and cuboids in {@link class_630}
 * Don't have to reinterpret the object...
 */
public final class ModelPartAccessor {

    public static Map<String,class_630> getChildren(class_630 modelPart){
        return ((IModelPartAccessor)modelPart).getChildren();
    }

    /**
     * Get a cuboid, and cast ist to {@link MutableCuboid}
     * Use {@link ModelPartAccessor#optionalGetCuboid(class_630, int)}
     * @param modelPart
     * @param index
     * @return
     */
    @Deprecated
    public static MutableCuboid getCuboid(class_630 modelPart, int index){
        Optional<MutableCuboid> optionalMutableCuboid = optionalGetCuboid(modelPart, index);
        return optionalMutableCuboid.orElseGet(DummyCuboid::new);
    }

    /**
     * Get a cuboid, and cast it to {@link MutableCuboid}
     *
     * @param modelPart
     * @param index
     * @return
     */
    public static Optional<MutableCuboid> optionalGetCuboid(class_630 modelPart, int index){
        if(modelPart == null || getCuboids(modelPart) == null || getCuboids(modelPart).size() <= index) return Optional.empty();
        return Optional.of((MutableCuboid)getCuboids(modelPart).get(index));
    }

    public static List<class_630.class_628> getCuboids(class_630 modelPart){
        return ((IModelPartAccessor)modelPart).getCuboids();
    }

    /**
     * Different workarounds to fix shared mod incompatibilities
     * If needed, I advice using {@link Workaround#VanillaDraw}. that is the most stable in any modded environment.
     */
    public enum Workaround {
        ExportQuads, VanillaDraw, None;
    }
}
