package io.github.kosmx.bendylib;

import io.github.kosmx.bendylib.impl.ICuboid;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import javax.annotation.Nullable;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_630;
import java.util.List;
import java.util.Map;

/**
 * ModelPart to support ICuboids
 *
 * If you want to mutate existing Cuboids, see {@link ModelPartAccessor} and {@link MutableCuboid}
 *
 * This can be used with {@link ICuboid}.
 */
public abstract class MutableModelPart extends class_630 {

    @Nullable
    @Deprecated
    private MutableModelPart last = null;

    protected final ObjectList<ICuboid> iCuboids = new ObjectArrayList<>();

    public MutableModelPart(List<class_628> cuboids, Map<String, class_630> ) {
        super(cuboids, );
    }


    @Override
    public void method_22699(class_4587 matrices, class_4588 , int , int , float , float , float , float ) {
        super.method_22699(matrices, , , , , , , );
        if(!iCuboids.isEmpty()){
            matrices.method_22903();
            this.method_22703(matrices);
            this.renderICuboids(matrices.method_23760(), , , , , , , );
            matrices.method_22909();
        }
    }

    protected void renderICuboids(class_4587.class_4665 matrices, class_4588 vertexConsumer, int light, int overlay, float red, float green, float blue, float alpha) {
        this.iCuboids.forEach((cuboid)-> cuboid.render(matrices, vertexConsumer, red, green, blue, alpha, light, overlay));
    }

    public void addICuboid(ICuboid cuboid){
        this.iCuboids.add(cuboid);
    }

}
