package io.github.kosmx.bendylib.impl;

import java.util.List;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_630;

/**
 * Minecraft Cuboid object
 * define it as you wish, render it as you wish!
 * You can use {@link BendableCuboid} to bend parts.
 */
public interface ICuboid {

    /**
     * See {@link BendableCuboid#render(class_4587.class_4665, class_4588, float, float, float, float, int, int)} how to do it
     * Or you can check the original MC code {@link net.minecraft.class_630#method_22699(class_4587, class_4588, int, int, float, float, float, float)}
     *
     * @param matrices Minecraft's Matrix transformation
     * @param vertexConsumer Minecraft Vertex consumer, add vertices to render
     * @param red red
     * @param green green
     * @param blue blue
     * @param alpha alpha
     * @param light light
     * @param overlay overlay
     */
    void render(class_4587.class_4665 matrices, class_4588 vertexConsumer, float red, float green, float blue, float alpha, int light, int overlay);

    /**
     * Copy custom state from another cuboid
     * @param other other ICuboid
     */
    void copyState(ICuboid other);

    /**
     * Disable mutation after invoking {@link ICuboid#render(class_4587.class_4665, class_4588, float, float, float, float, int, int)}
     * @return true or false...
     */
    default boolean disableAfterDraw(){
        return true;
    }

    /**
     * Convert custom Quads to {@link net.minecraft.class_630.class_593}
     * Needed for Shader fix
     * @return list of converted quads
     */
    default List<class_630.class_593> getQuads(){
        return null;
    }
}
