/*
 * Decompiled with CFR 0.152.
 */
package io.github.kryszak.gwatlin.api.account;

import io.github.kryszak.gwatlin.api.account.model.Account;
import io.github.kryszak.gwatlin.api.account.model.AccountAchievement;
import io.github.kryszak.gwatlin.api.account.model.AccountFinisher;
import io.github.kryszak.gwatlin.api.account.model.AccountLuck;
import io.github.kryszak.gwatlin.api.account.model.CurrencyAmount;
import io.github.kryszak.gwatlin.api.account.model.InventoryItem;
import io.github.kryszak.gwatlin.api.account.model.mastery.AccountMastery;
import io.github.kryszak.gwatlin.api.account.model.mastery.AccountMasteryDetails;
import io.github.kryszak.gwatlin.api.account.model.vault.AccountBankSlot;
import io.github.kryszak.gwatlin.api.account.model.vault.AccountMaterial;
import io.github.kryszak.gwatlin.api.exception.ApiRequestException;
import io.github.kryszak.gwatlin.api.homeinstance.model.Cat;
import io.github.kryszak.gwatlin.clients.account.AccountClient;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\bJ\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\bJ\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\bJ\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\bJ\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\bJ\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\bJ\u000e\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\bJ\u0006\u0010\u0018\u001a\u00020\u0019J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00150\bJ\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00030\bJ\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\bJ\u0006\u0010\u001e\u001a\u00020\u001fJ\f\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\bJ\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00150\bJ\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00150\bJ\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030\bJ\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00030\bJ\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00150\bJ\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00150\bJ\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00150\bJ\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00030\bJ\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00150\bJ\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00150\bJ\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00150\bJ\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00150\bJ\f\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\bJ\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u00030\bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lio/github/kryszak/gwatlin/api/account/GWAccountClient;", "", "apiKey", "", "(Ljava/lang/String;)V", "accountClient", "Lio/github/kryszak/gwatlin/clients/account/AccountClient;", "getAccountAchievements", "", "Lio/github/kryszak/gwatlin/api/account/model/AccountAchievement;", "getAccountDailyCrafting", "getAccountDetails", "Lio/github/kryszak/gwatlin/api/account/model/Account;", "getAccountVault", "Lio/github/kryszak/gwatlin/api/account/model/vault/AccountBankSlot;", "getCats", "Lio/github/kryszak/gwatlin/api/homeinstance/model/Cat;", "getCompletedDailyDungeons", "getFinishers", "Lio/github/kryszak/gwatlin/api/account/model/AccountFinisher;", "getGliders", "", "getInventory", "Lio/github/kryszak/gwatlin/api/account/model/InventoryItem;", "getLuck", "Lio/github/kryszak/gwatlin/api/account/model/AccountLuck;", "getMailCarriers", "getMapChests", "getMasteries", "Lio/github/kryszak/gwatlin/api/account/model/mastery/AccountMastery;", "getMasteryDetails", "Lio/github/kryszak/gwatlin/api/account/model/mastery/AccountMasteryDetails;", "getMaterials", "Lio/github/kryszak/gwatlin/api/account/model/vault/AccountMaterial;", "getMinis", "getMountSkins", "getMountTypes", "getNodes", "getNovelties", "getOutfits", "getPvpHeroes", "getRaids", "getRecipes", "getSkins", "getTitles", "getUnlockedDyes", "getWallet", "Lio/github/kryszak/gwatlin/api/account/model/CurrencyAmount;", "getWorldBosses", "gwatlin"})
public final class GWAccountClient {
    @NotNull
    private final AccountClient accountClient;

    public GWAccountClient(@NotNull String apiKey) {
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        this.accountClient = new AccountClient(apiKey);
    }

    @NotNull
    public final Account getAccountDetails() {
        return this.accountClient.getAccountDetails();
    }

    @NotNull
    public final List<AccountAchievement> getAccountAchievements() {
        return this.accountClient.getAccountAchievements();
    }

    @NotNull
    public final List<AccountBankSlot> getAccountVault() {
        return this.accountClient.getAccountVault();
    }

    @NotNull
    public final List<String> getAccountDailyCrafting() {
        return this.accountClient.getDailyCrafting();
    }

    @NotNull
    public final List<String> getCompletedDailyDungeons() {
        return this.accountClient.getCompletedDailyDungeons();
    }

    @NotNull
    public final List<Integer> getUnlockedDyes() {
        return this.accountClient.getUnlockedDyes();
    }

    @NotNull
    public final List<AccountFinisher> getFinishers() {
        return this.accountClient.getFinishers();
    }

    @NotNull
    public final List<Integer> getGliders() {
        return this.accountClient.getGliders();
    }

    @NotNull
    public final List<Cat> getCats() {
        return this.accountClient.getCats();
    }

    @NotNull
    public final List<String> getNodes() {
        return this.accountClient.getNodes();
    }

    @NotNull
    public final List<InventoryItem> getInventory() {
        return this.accountClient.getInventory();
    }

    @NotNull
    public final AccountLuck getLuck() {
        List<AccountLuck> luck = this.accountClient.getLuck();
        return switch (luck.size()) {
            case 1 -> luck.get(0);
            case 0 -> new AccountLuck("luck", 0);
            default -> throw new ApiRequestException("No luck");
        };
    }

    @NotNull
    public final List<Integer> getMailCarriers() {
        return this.accountClient.getMailCarriers();
    }

    @NotNull
    public final List<String> getMapChests() {
        return this.accountClient.getMapChests();
    }

    @NotNull
    public final List<AccountMastery> getMasteries() {
        return this.accountClient.getMasteries();
    }

    @NotNull
    public final AccountMasteryDetails getMasteryDetails() {
        return this.accountClient.getMasteryDetails();
    }

    @NotNull
    public final List<AccountMaterial> getMaterials() {
        return this.accountClient.getMaterials();
    }

    @NotNull
    public final List<Integer> getMinis() {
        return this.accountClient.getMinis();
    }

    @NotNull
    public final List<Integer> getMountSkins() {
        return this.accountClient.getMountSkins();
    }

    @NotNull
    public final List<String> getMountTypes() {
        return this.accountClient.getMountTypes();
    }

    @NotNull
    public final List<Integer> getNovelties() {
        return this.accountClient.getNovelties();
    }

    @NotNull
    public final List<Integer> getOutfits() {
        return this.accountClient.getOutfits();
    }

    @NotNull
    public final List<Integer> getPvpHeroes() {
        return this.accountClient.getPvpHeroes();
    }

    @NotNull
    public final List<String> getRaids() {
        return this.accountClient.getRaids();
    }

    @NotNull
    public final List<Integer> getRecipes() {
        return this.accountClient.getRecipes();
    }

    @NotNull
    public final List<Integer> getSkins() {
        return this.accountClient.getSkins();
    }

    @NotNull
    public final List<Integer> getTitles() {
        return this.accountClient.getTitles();
    }

    @NotNull
    public final List<CurrencyAmount> getWallet() {
        return this.accountClient.getWallet();
    }

    @NotNull
    public final List<String> getWorldBosses() {
        return this.accountClient.getWorldBosses();
    }
}

