/*
 * Decompiled with CFR 0.152.
 */
package io.github.kryszak.gwatlin.api.characters;

import io.github.kryszak.gwatlin.api.characters.model.Character;
import io.github.kryszak.gwatlin.api.characters.model.character.BuildTab;
import io.github.kryszak.gwatlin.api.characters.model.character.CharacterCore;
import io.github.kryszak.gwatlin.api.characters.model.character.Crafting;
import io.github.kryszak.gwatlin.api.characters.model.character.Training;
import io.github.kryszak.gwatlin.api.characters.model.character.equipment.EquipmentItem;
import io.github.kryszak.gwatlin.api.characters.model.character.equipment.EquipmentTab;
import io.github.kryszak.gwatlin.api.characters.model.character.inventory.Bag;
import io.github.kryszak.gwatlin.api.characters.model.character.sab.CharacterSAB;
import io.github.kryszak.gwatlin.clients.characters.CharactersClient;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0003J\u0016\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\r2\u0006\u0010\t\u001a\u00020\u0003J\u0016\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010J\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\r2\u0006\u0010\t\u001a\u00020\u0003J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\u0003J\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\rJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\u0003J\u0016\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\r2\u0006\u0010\t\u001a\u00020\u0003J\u0016\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\r2\u0006\u0010\t\u001a\u00020\u0003J\u0016\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010J\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\u0006\u0010\t\u001a\u00020\u0003J\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00030\r2\u0006\u0010\t\u001a\u00020\u0003J\u0018\u0010\u001e\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u001f\u0018\u00010\r2\u0006\u0010\t\u001a\u00020\u0003J\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00100\r2\u0006\u0010\t\u001a\u00020\u0003J\u0016\u0010!\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\r2\u0006\u0010\t\u001a\u00020\u0003J\u000e\u0010\"\u001a\u00020#2\u0006\u0010\t\u001a\u00020\u0003J\u0016\u0010$\u001a\n\u0012\u0004\u0012\u00020%\u0018\u00010\r2\u0006\u0010\t\u001a\u00020\u0003R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lio/github/kryszak/gwatlin/api/characters/GWCharactersClient;", "", "apiKey", "", "(Ljava/lang/String;)V", "charactersClient", "Lio/github/kryszak/gwatlin/clients/characters/CharactersClient;", "getActiveBuildTab", "Lio/github/kryszak/gwatlin/api/characters/model/character/BuildTab;", "characterName", "getActiveEquipmentTab", "Lio/github/kryszak/gwatlin/api/characters/model/character/equipment/EquipmentTab;", "getBackstory", "", "getBuildTab", "tab", "", "getBuildTabs", "getCharacter", "Lio/github/kryszak/gwatlin/api/characters/model/Character;", "getCharacters", "getCore", "Lio/github/kryszak/gwatlin/api/characters/model/character/CharacterCore;", "getCrafting", "Lio/github/kryszak/gwatlin/api/characters/model/character/Crafting;", "getEquipment", "Lio/github/kryszak/gwatlin/api/characters/model/character/equipment/EquipmentItem;", "getEquipmentTab", "getEquipmentTabs", "getHeropoints", "getInventory", "Lio/github/kryszak/gwatlin/api/characters/model/character/inventory/Bag;", "getQuests", "getRecipes", "getSAB", "Lio/github/kryszak/gwatlin/api/characters/model/character/sab/CharacterSAB;", "getTraining", "Lio/github/kryszak/gwatlin/api/characters/model/character/Training;", "gwatlin"})
public final class GWCharactersClient {
    @NotNull
    private final CharactersClient charactersClient;

    public GWCharactersClient(@NotNull String apiKey) {
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        this.charactersClient = new CharactersClient(apiKey);
    }

    @NotNull
    public final List<String> getCharacters() {
        return this.charactersClient.getCharacters();
    }

    @NotNull
    public final Character getCharacter(@NotNull String characterName) {
        Intrinsics.checkNotNullParameter((Object)characterName, (String)"characterName");
        return this.charactersClient.getCharacter(characterName);
    }

    @Nullable
    public final List<String> getBackstory(@NotNull String characterName) {
        Intrinsics.checkNotNullParameter((Object)characterName, (String)"characterName");
        return this.charactersClient.getBackstory(characterName);
    }

    @NotNull
    public final BuildTab getBuildTab(@NotNull String characterName, int tab) {
        Intrinsics.checkNotNullParameter((Object)characterName, (String)"characterName");
        return this.charactersClient.getBuildTab(characterName, tab);
    }

    @NotNull
    public final List<BuildTab> getBuildTabs(@NotNull String characterName) {
        Intrinsics.checkNotNullParameter((Object)characterName, (String)"characterName");
        return this.charactersClient.getBuildTabs(characterName);
    }

    @NotNull
    public final CharacterCore getCore(@NotNull String characterName) {
        Intrinsics.checkNotNullParameter((Object)characterName, (String)"characterName");
        return this.charactersClient.getCore(characterName);
    }

    @Nullable
    public final List<Crafting> getCrafting(@NotNull String characterName) {
        Intrinsics.checkNotNullParameter((Object)characterName, (String)"characterName");
        return this.charactersClient.getCrafting(characterName);
    }

    @Nullable
    public final List<EquipmentItem> getEquipment(@NotNull String characterName) {
        Intrinsics.checkNotNullParameter((Object)characterName, (String)"characterName");
        return this.charactersClient.getEquipment(characterName);
    }

    @NotNull
    public final EquipmentTab getEquipmentTab(@NotNull String characterName, int tab) {
        Intrinsics.checkNotNullParameter((Object)characterName, (String)"characterName");
        return this.charactersClient.getEquipmentTab(characterName, tab);
    }

    @NotNull
    public final List<EquipmentTab> getEquipmentTabs(@NotNull String characterName) {
        Intrinsics.checkNotNullParameter((Object)characterName, (String)"characterName");
        return this.charactersClient.getEquipmentTabs(characterName);
    }

    @Nullable
    public final List<Bag> getInventory(@NotNull String characterName) {
        Intrinsics.checkNotNullParameter((Object)characterName, (String)"characterName");
        return this.charactersClient.getInventory(characterName);
    }

    @Nullable
    public final List<Integer> getRecipes(@NotNull String characterName) {
        Intrinsics.checkNotNullParameter((Object)characterName, (String)"characterName");
        return this.charactersClient.getRecipes(characterName);
    }

    @Nullable
    public final List<Training> getTraining(@NotNull String characterName) {
        Intrinsics.checkNotNullParameter((Object)characterName, (String)"characterName");
        return this.charactersClient.getTraining(characterName);
    }

    @NotNull
    public final BuildTab getActiveBuildTab(@NotNull String characterName) {
        Intrinsics.checkNotNullParameter((Object)characterName, (String)"characterName");
        return this.charactersClient.getActiveBuildTab(characterName);
    }

    @NotNull
    public final EquipmentTab getActiveEquipmentTab(@NotNull String characterName) {
        Intrinsics.checkNotNullParameter((Object)characterName, (String)"characterName");
        return this.charactersClient.getActiveEquipmentTab(characterName);
    }

    @NotNull
    public final List<String> getHeropoints(@NotNull String characterName) {
        Intrinsics.checkNotNullParameter((Object)characterName, (String)"characterName");
        return this.charactersClient.getHeropoints(characterName);
    }

    @NotNull
    public final List<Integer> getQuests(@NotNull String characterName) {
        Intrinsics.checkNotNullParameter((Object)characterName, (String)"characterName");
        return this.charactersClient.getQuests(characterName);
    }

    @NotNull
    public final CharacterSAB getSAB(@NotNull String characterName) {
        Intrinsics.checkNotNullParameter((Object)characterName, (String)"characterName");
        return this.charactersClient.getSAB(characterName);
    }
}

