/*
 * Decompiled with CFR 0.152.
 */
package io.github.kryszak.gwatlin.http;

import com.github.kittinunf.fuel.FuelKt;
import com.github.kittinunf.fuel.core.Deserializable;
import com.github.kittinunf.fuel.core.DeserializableKt;
import com.github.kittinunf.fuel.core.Request;
import com.github.kittinunf.fuel.core.Response;
import com.github.kittinunf.fuel.core.ResponseDeserializable;
import com.github.kittinunf.result.Result;
import io.github.kryszak.gwatlin.api.ApiLanguage;
import io.github.kryszak.gwatlin.api.exception.ApiRequestException;
import io.github.kryszak.gwatlin.http.BaseHttpClient;
import io.github.kryszak.gwatlin.http.config.HttpConfig;
import io.github.kryszak.gwatlin.http.exception.ErrorResponse;
import io.github.kryszak.gwatlin.http.exception.RetrieveError;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MagicApiIntrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonKt;
import kotlinx.serialization.modules.SerializersModule;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0010\u0018\u00002\u00020\u0001B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0004J\u0010\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003H\u0004JL\u0010\u0015\u001a\u0002H\u0016\"\n\b\u0000\u0010\u0016\u0018\u0001*\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u00032\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0019\b\u0002\u0010\u0018\u001a\u0013\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u000e0\u0019\u00a2\u0006\u0002\b\u001aH\u0084\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001bJG\u0010\u001c\u001a\u0002H\u0016\"\b\b\u0000\u0010\u0016*\u00020\u0001\"\b\b\u0001\u0010\u001d*\u00020\u00012\u0016\u0010\u001e\u001a\u0012\u0012\u0004\u0012\u0002H\u0016\u0012\b\u0012\u00060 j\u0002`!0\u001f2\f\u0010\"\u001a\b\u0012\u0004\u0012\u0002H\u001d0#H\u0004\u00a2\u0006\u0002\u0010$R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006%"}, d2={"Lio/github/kryszak/gwatlin/http/BaseHttpClient;", "", "schemaVersion", "", "(Ljava/lang/String;)V", "baseUrl", "httpConfig", "Lio/github/kryszak/gwatlin/http/config/HttpConfig;", "json", "Lkotlinx/serialization/json/Json;", "log", "Lmu/KLogger;", "logMessage", "addDefaultHeaders", "", "request", "Lcom/github/kittinunf/fuel/core/Request;", "language", "Lio/github/kryszak/gwatlin/api/ApiLanguage;", "encodeParam", "param", "getRequest", "T", "uri", "configBlock", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "(Ljava/lang/String;Lio/github/kryszak/gwatlin/api/ApiLanguage;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "processResult", "E", "result", "Lcom/github/kittinunf/result/Result;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "errorResponse", "Lio/github/kryszak/gwatlin/http/exception/ErrorResponse;", "(Lcom/github/kittinunf/result/Result;Lio/github/kryszak/gwatlin/http/exception/ErrorResponse;)Ljava/lang/Object;", "gwatlin"})
@SourceDebugExtension(value={"SMAP\nBaseHttpClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseHttpClient.kt\nio/github/kryszak/gwatlin/http/BaseHttpClient\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 FuelSerialization.kt\ncom/github/kittinunf/fuel/serialization/FuelSerializationKt\n*L\n1#1,78:1\n1#2:79\n44#3,21:80\n*S KotlinDebug\n*F\n+ 1 BaseHttpClient.kt\nio/github/kryszak/gwatlin/http/BaseHttpClient\n*L\n49#1:80,21\n*E\n"})
public class BaseHttpClient {
    @Nullable
    private final String schemaVersion;
    @NotNull
    private final KLogger log;
    @NotNull
    private final String logMessage;
    @NotNull
    private final String baseUrl;
    @NotNull
    private final Json json;
    @NotNull
    private final HttpConfig httpConfig;

    public BaseHttpClient(@Nullable String schemaVersion) {
        this.schemaVersion = schemaVersion;
        this.log = KotlinLogging.INSTANCE.logger((Function0)log.1.INSTANCE);
        this.logMessage = "Requested url: %s";
        this.json = JsonKt.Json$default(null, (Function1)json.1.INSTANCE, (int)1, null);
        this.httpConfig = new HttpConfig();
        this.baseUrl = this.httpConfig.getBaseUrl();
    }

    public /* synthetic */ BaseHttpClient(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        this(string);
    }

    /*
     * WARNING - void declaration
     */
    protected final /* synthetic */ <T> T getRequest(String uri, ApiLanguage language, Function1<? super Request, Unit> configBlock) {
        void loader$iv;
        void $this$responseObject$iv;
        Request request;
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter(configBlock, (String)"configBlock");
        boolean $i$f$getRequest = false;
        Request it = request = FuelKt.httpGet$default((String)(this.baseUrl + "/" + uri), null, (int)1, null);
        boolean bl = false;
        this.addDefaultHeaders(it, language);
        it = request;
        boolean bl2 = false;
        KLogger kLogger = this.log;
        String string = this.logMessage;
        Object[] objectArray = new Object[]{it.getUrl()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        kLogger.info(string2);
        it = request;
        boolean bl3 = false;
        configBlock.invoke((Object)it);
        it = this.json.getSerializersModule();
        Intrinsics.reifiedOperationMarker((int)6, (String)"T");
        MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
        it = (DeserializationStrategy)SerializersKt.serializer((SerializersModule)it, null);
        Json json$iv = this.json;
        boolean $i$f$responseObject = false;
        boolean $i$f$kotlinxDeserializerOf = false;
        Intrinsics.needClassReification();
        Triple triple = DeserializableKt.response((Request)$this$responseObject$iv, (Deserializable)((Deserializable)new ResponseDeserializable<T>(json$iv, (DeserializationStrategy)loader$iv){
            final /* synthetic */ Json $json;
            final /* synthetic */ DeserializationStrategy $loader;
            {
                this.$json = $captured_local_variable$0;
                this.$loader = $captured_local_variable$1;
            }

            @Nullable
            public T deserialize(@NotNull String content) {
                Intrinsics.checkNotNullParameter((Object)content, (String)"content");
                return (T)this.$json.decodeFromString(this.$loader, content);
            }

            @Nullable
            public T deserialize(@NotNull Reader reader) {
                Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
                return this.deserialize(TextStreamsKt.readText((Reader)reader));
            }

            @Nullable
            public T deserialize(@NotNull byte[] bytes) {
                Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
                return this.deserialize(new String(bytes, Charsets.UTF_8));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Nullable
            public T deserialize(@NotNull InputStream inputStream) {
                Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
                Closeable closeable = inputStream;
                Charset charset = Charsets.UTF_8;
                Closeable closeable2 = closeable;
                closeable2 = new InputStreamReader((InputStream)closeable2, charset);
                int n = 8192;
                closeable = closeable2 instanceof BufferedReader ? (BufferedReader)closeable2 : new BufferedReader((Reader)closeable2, n);
                Throwable throwable = null;
                try {
                    BufferedReader it = (BufferedReader)closeable;
                    boolean bl = false;
                    T t = this.deserialize(it);
                    return t;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }

            @NotNull
            public T deserialize(@NotNull Response response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                return (T)ResponseDeserializable.DefaultImpls.deserialize((ResponseDeserializable)this, (Response)response);
            }
        }));
        Response response = (Response)triple.component2();
        Result result = (Result)triple.component3();
        return (T)this.processResult(result, new ErrorResponse(response, (DeserializationStrategy)RetrieveError.Companion.serializer()));
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ Object getRequest$default(BaseHttpClient $this, String uri, ApiLanguage language, Function1 configBlock, int n, Object object) {
        void loader$iv;
        void $this$responseObject$iv;
        Request request;
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getRequest");
        }
        if ((n & 2) != 0) {
            language = null;
        }
        if ((n & 4) != 0) {
            configBlock = getRequest.1.INSTANCE;
        }
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)configBlock, (String)"configBlock");
        boolean $i$f$getRequest = false;
        Request it = request = FuelKt.httpGet$default((String)($this.baseUrl + "/" + uri), null, (int)1, null);
        boolean bl = false;
        $this.addDefaultHeaders(it, language);
        it = request;
        boolean bl2 = false;
        KLogger kLogger = $this.log;
        String string = $this.logMessage;
        Object[] objectArray = new Object[]{it.getUrl()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        kLogger.info(string2);
        it = request;
        boolean bl3 = false;
        configBlock.invoke((Object)it);
        it = $this.json.getSerializersModule();
        Intrinsics.reifiedOperationMarker((int)6, (String)"T");
        MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
        it = (DeserializationStrategy)SerializersKt.serializer((SerializersModule)it, null);
        Json json$iv = $this.json;
        boolean $i$f$responseObject = false;
        boolean $i$f$kotlinxDeserializerOf = false;
        Intrinsics.needClassReification();
        object = DeserializableKt.response((Request)$this$responseObject$iv, (Deserializable)((Deserializable)new /* invalid duplicate definition of identical inner class */));
        Response response = (Response)object.component2();
        Result result = (Result)object.component3();
        return $this.processResult(result, new ErrorResponse(response, (DeserializationStrategy)RetrieveError.Companion.serializer()));
    }

    protected final void addDefaultHeaders(@NotNull Request request, @Nullable ApiLanguage language) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            String string = this.schemaVersion;
            if (string != null) {
                String it = string;
                boolean bl = false;
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"X-Schema-Version", (Object)it)};
                request.appendHeader(pairArray);
            }
            ApiLanguage apiLanguage = language;
            if (apiLanguage == null) break block1;
            ApiLanguage it = apiLanguage;
            boolean bl = false;
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"Accept-Language", (Object)it.getApiString())};
            request.appendHeader(pairArray);
        }
    }

    @NotNull
    protected final String encodeParam(@NotNull String param) {
        Intrinsics.checkNotNullParameter((Object)param, (String)"param");
        return StringsKt.replace$default((String)param, (String)" ", (String)"%20", (boolean)false, (int)4, null);
    }

    @NotNull
    protected final <T, E> T processResult(@NotNull Result<? extends T, ? extends Exception> result, @NotNull ErrorResponse<E> errorResponse) {
        Intrinsics.checkNotNullParameter(result, (String)"result");
        Intrinsics.checkNotNullParameter(errorResponse, (String)"errorResponse");
        Result<? extends T, ? extends Exception> result2 = result;
        if (result2 instanceof Result.Success) {
            return (T)result.get();
        }
        if (result2 instanceof Result.Failure) {
            this.log.error("Request failed! " + ((Result.Failure)result).getException().getMessage());
            try {
                Object error = this.json.decodeFromString(errorResponse.getDeserializationStrategy(), new String(errorResponse.getResponse().getData(), Charsets.UTF_8));
                this.log.error("Error: " + error);
                throw new ApiRequestException(error.toString());
            }
            catch (IllegalStateException e) {
                this.log.warn("Failed to deserialize error response", (Throwable)e);
                throw new ApiRequestException("Unknown error");
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    public BaseHttpClient() {
        this(null, 1, null);
    }
}

