/*
 * Decompiled with CFR 0.152.
 */
package com.kwai.network.sdk.api;

import android.text.TextUtils;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.kuaishou.commercial.utility.ioc.interfaces.Service;
import com.kwai.network.sdk.annotations.KwaiAdSdkApi;
import com.kwai.network.sdk.api.EmptyInitCallback;
import com.kwai.network.sdk.api.KwaiInitCallback;
import com.kwai.network.sdk.core.KwaiCustomController;

@KwaiAdSdkApi
@Keep
public class SdkConfig
implements Service {
    @KwaiAdSdkApi
    @Nullable
    @Keep
    public String appId;
    @KwaiAdSdkApi
    @Nullable
    @Keep
    public String token;
    @KwaiAdSdkApi
    @Nullable
    @Keep
    public String appName;
    @KwaiAdSdkApi
    @Nullable
    @Keep
    public String appDomain;
    @KwaiAdSdkApi
    @Nullable
    @Keep
    public String appStoreUrl;
    @KwaiAdSdkApi
    @Keep
    public boolean enableDebug;
    @KwaiAdSdkApi
    @Nullable
    @Keep
    public KwaiCustomController mKwaiCustomController;
    @NonNull
    public KwaiInitCallback ksInitCallback;

    @KwaiAdSdkApi
    @Keep
    private SdkConfig(Builder builder) {
        this.enableDebug = builder.enableDebug;
        this.appId = builder.appId;
        this.token = builder.token;
        this.appName = builder.appName;
        this.appDomain = builder.appDomain;
        this.appStoreUrl = builder.appStoreUrl;
        this.mKwaiCustomController = builder.mKwaiCustomController;
        this.ksInitCallback = builder.ksInitCallback == null ? new EmptyInitCallback() : builder.ksInitCallback;
    }

    public boolean isInvalid() {
        return TextUtils.isEmpty((CharSequence)this.appId) && TextUtils.isEmpty((CharSequence)this.token);
    }

    @KwaiAdSdkApi
    @Keep
    public static class Builder {
        private boolean enableDebug;
        @Nullable
        private String appId;
        @Nullable
        private String token;
        @Nullable
        private String appName;
        @Nullable
        public String appDomain;
        @Nullable
        public String appStoreUrl;
        @Nullable
        private KwaiCustomController mKwaiCustomController;
        @Nullable
        private KwaiInitCallback ksInitCallback;

        @KwaiAdSdkApi
        @Keep
        public Builder() {
        }

        @KwaiAdSdkApi
        @Keep
        public Builder debug(boolean enableDebug) {
            this.enableDebug = enableDebug;
            return this;
        }

        @KwaiAdSdkApi
        @Keep
        public Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        @KwaiAdSdkApi
        @Keep
        public Builder token(String token) {
            this.token = token;
            return this;
        }

        @KwaiAdSdkApi
        @Keep
        public Builder appName(String appName) {
            this.appName = appName;
            return this;
        }

        @KwaiAdSdkApi
        @Keep
        public Builder appDomain(String appDomain) {
            this.appDomain = appDomain;
            return this;
        }

        @KwaiAdSdkApi
        @Keep
        public Builder appStoreUrl(String appStoreUrl) {
            this.appStoreUrl = appStoreUrl;
            return this;
        }

        @KwaiAdSdkApi
        @Keep
        public Builder customController(KwaiCustomController customController) {
            this.mKwaiCustomController = customController;
            return this;
        }

        @KwaiAdSdkApi
        @Keep
        public Builder setInitCallback(KwaiInitCallback initCallback) {
            this.ksInitCallback = initCallback;
            return this;
        }

        @KwaiAdSdkApi
        @Keep
        public SdkConfig build() {
            return new SdkConfig(this);
        }
    }
}

