/*
 * Decompiled with CFR 0.152.
 */
package com.kwai.network.maxadapter;

import android.app.Activity;
import android.content.Context;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.adapter.MaxAdapter;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.MaxInterstitialAdapter;
import com.applovin.mediation.adapter.MaxRewardedAdapter;
import com.applovin.mediation.adapter.listeners.MaxInterstitialAdapterListener;
import com.applovin.mediation.adapter.listeners.MaxRewardedAdapterListener;
import com.applovin.mediation.adapter.parameters.MaxAdapterInitializationParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterParameters;
import com.applovin.mediation.adapter.parameters.MaxAdapterResponseParameters;
import com.applovin.mediation.adapters.MediationAdapterBase;
import com.applovin.sdk.AppLovinSdk;
import com.kwai.network.maxadapter.feature.Interstitial.KwaiInterstitialAdListener;
import com.kwai.network.maxadapter.feature.Interstitial.KwaiInterstitialAdLoaderListener;
import com.kwai.network.maxadapter.feature.base.interf.ILogListener;
import com.kwai.network.maxadapter.feature.reward.KwaiRewardAdListener;
import com.kwai.network.maxadapter.feature.reward.KwaiRewardAdLoaderListener;
import com.kwai.network.maxadapter.model.KwaiInitialize;
import com.kwai.network.sdk.KwaiAdSDK;
import com.kwai.network.sdk.api.KwaiAdLoaderManager;
import com.kwai.network.sdk.api.KwaiInitCallback;
import com.kwai.network.sdk.api.SdkConfig;
import com.kwai.network.sdk.constant.KwaiError;
import com.kwai.network.sdk.loader.business.interstitial.data.KwaiInterstitialAd;
import com.kwai.network.sdk.loader.business.interstitial.data.KwaiInterstitialAdConfig;
import com.kwai.network.sdk.loader.business.interstitial.data.KwaiInterstitialAdRequest;
import com.kwai.network.sdk.loader.business.interstitial.interf.IKwaiInterstitialAdListener;
import com.kwai.network.sdk.loader.business.reward.data.KwaiRewardAd;
import com.kwai.network.sdk.loader.business.reward.data.KwaiRewardAdConfig;
import com.kwai.network.sdk.loader.business.reward.data.KwaiRewardAdRequest;
import com.kwai.network.sdk.loader.business.reward.interf.IKwaiRewardAdListener;
import com.kwai.network.sdk.loader.common.KwaiAdRequest;
import com.kwai.network.sdk.loader.common.interf.AdLoadListener;
import com.kwai.network.sdk.loader.common.interf.IKwaiAdLoader;
import java.util.concurrent.atomic.AtomicBoolean;

@Keep
public class KwaiMaxMediationAdapter
extends MediationAdapterBase
implements MaxInterstitialAdapter,
MaxRewardedAdapter,
KwaiRewardAdListener.IRewardListener,
ILogListener {
    private static final AtomicBoolean sInitialized = new AtomicBoolean(false);
    @Nullable
    private IKwaiAdLoader<KwaiRewardAdRequest> mRewardLoader = null;
    @Nullable
    private KwaiInterstitialAdLoaderListener mKwaiInterstitialAdLoaderListener = null;
    @Nullable
    private IKwaiAdLoader<KwaiInterstitialAdRequest> mInterstitialLoader = null;
    @Nullable
    private KwaiRewardAdLoaderListener mKwaiRewardAdLoaderListener = null;

    public KwaiMaxMediationAdapter(AppLovinSdk appLovinSdk) {
        super(appLovinSdk);
    }

    public void initialize(@NonNull MaxAdapterInitializationParameters maxAdapterInitializationParameters, @Nullable Activity activity, final @NonNull MaxAdapter.OnCompletionListener onCompletionListener) {
        this.logInfo("KwaiMediationAdapterBase initialize");
        if (sInitialized.compareAndSet(false, true)) {
            Context context = activity == null ? this.getApplicationContext() : activity.getApplicationContext();
            KwaiInitialize kwaiInitialize = new KwaiInitialize((MaxAdapterParameters)maxAdapterInitializationParameters);
            this.logInfo("KwaiMediationAdapterBase init params" + kwaiInitialize);
            KwaiAdSDK.init((Context)context, (SdkConfig)new SdkConfig.Builder().appId(kwaiInitialize.appId).token(kwaiInitialize.token).appName(kwaiInitialize.appName).appDomain(kwaiInitialize.domain).appStoreUrl(kwaiInitialize.storeUrl).debug(true).setInitCallback(new KwaiInitCallback(){

                public void onSuccess() {
                    KwaiMaxMediationAdapter.this.logInfo("KwaiMediationAdapterBase initialize onSuccess");
                    onCompletionListener.onCompletion(MaxAdapter.InitializationStatus.INITIALIZED_SUCCESS, "init success");
                }

                public void onFail(int code, String msg) {
                    KwaiMaxMediationAdapter.this.logInfo("KwaiMediationAdapterBase initialize onFail code = " + code + ", msg = " + msg);
                    onCompletionListener.onCompletion(MaxAdapter.InitializationStatus.INITIALIZED_FAILURE, "code = " + code + " msg = " + msg);
                    sInitialized.set(false);
                }
            }).build());
        }
    }

    public String getSdkVersion() {
        return KwaiAdSDK.getSDKVersion();
    }

    public String getAdapterVersion() {
        return KwaiAdSDK.getSDKVersion();
    }

    public void onDestroy() {
        this.releaseInterstitial();
        this.releaseReward();
    }

    @Override
    public void logInfo(@NonNull String message) {
        this.log(message);
    }

    @Override
    public void logError(@NonNull String message, @Nullable Throwable throwable) {
        this.log(message, throwable);
    }

    public void loadInterstitialAd(@NonNull MaxAdapterResponseParameters maxAdapterResponseParameters, @Nullable Activity activity, @NonNull MaxInterstitialAdapterListener maxInterstitialAdapterListener) {
        this.logInfo("loadInterstitialAd");
        KwaiAdLoaderManager kwaiAdLoaderManager = KwaiAdSDK.getKwaiAdLoaderManager();
        if (kwaiAdLoaderManager != null) {
            this.mKwaiInterstitialAdLoaderListener = new KwaiInterstitialAdLoaderListener(this, maxInterstitialAdapterListener);
            IKwaiAdLoader interstitialAdLoader = kwaiAdLoaderManager.buildInterstitialAdLoader(new KwaiInterstitialAdConfig.Builder((AdLoadListener)this.mKwaiInterstitialAdLoaderListener).withKwaiInterstitialAdListener((IKwaiInterstitialAdListener)new KwaiInterstitialAdListener(this, maxInterstitialAdapterListener)).build());
            KwaiInitialize kwaiInitialize = new KwaiInitialize((MaxAdapterParameters)maxAdapterResponseParameters);
            String tagId = kwaiInitialize.tagId;
            String floorPrice = kwaiInitialize.floorPrice;
            this.logInfo("loadInterstitialAd tagId = " + tagId + ", floorPrice = " + floorPrice);
            KwaiInterstitialAdRequest kwaiInterstitialAdRequest = new KwaiInterstitialAdRequest(tagId);
            this.appendExtInfo((KwaiAdRequest)kwaiInterstitialAdRequest, floorPrice);
            interstitialAdLoader.loadAd((KwaiAdRequest)kwaiInterstitialAdRequest);
        } else {
            this.logInfo("loadInterstitialAd kwaiAdLoaderManager is null");
            maxInterstitialAdapterListener.onInterstitialAdLoadFailed(MaxAdapterError.NOT_INITIALIZED);
        }
    }

    private void appendExtInfo(@NonNull KwaiAdRequest kwaiAdRequest, String floorPrice) {
        kwaiAdRequest.extParams.put("knMediationType", String.valueOf(1));
        kwaiAdRequest.extParams.put("bidfloor", floorPrice);
    }

    public void showInterstitialAd(@NonNull MaxAdapterResponseParameters maxAdapterResponseParameters, @NonNull Activity activity, @NonNull MaxInterstitialAdapterListener maxInterstitialAdapterListener) {
        this.logInfo("showInterstitialAd");
        if (this.mKwaiInterstitialAdLoaderListener != null) {
            if (this.mKwaiInterstitialAdLoaderListener.adResult != null) {
                KwaiInterstitialAd adResult = (KwaiInterstitialAd)this.mKwaiInterstitialAdLoaderListener.adResult;
                if (adResult.isReady()) {
                    this.logInfo("showInterstitialAd ad show");
                    adResult.show(activity);
                } else {
                    this.logInfo("showInterstitialAd ad is not ready");
                    maxInterstitialAdapterListener.onInterstitialAdLoadFailed(MaxAdapterError.AD_NOT_READY);
                }
            } else if (this.mKwaiInterstitialAdLoaderListener.mKwaiError != null) {
                KwaiError kwaiError = this.mKwaiInterstitialAdLoaderListener.mKwaiError;
                this.logInfo("showInterstitialAd code = " + kwaiError.getCode() + " msg = " + kwaiError.getMsg());
                maxInterstitialAdapterListener.onInterstitialAdLoadFailed(new MaxAdapterError(kwaiError.getCode(), kwaiError.getMsg()));
            } else {
                this.logInfo("showInterstitialAd time out");
                maxInterstitialAdapterListener.onInterstitialAdLoadFailed(MaxAdapterError.TIMEOUT);
            }
        } else {
            this.logInfo("showInterstitialAd internal error, \u5c55\u793a\u7684\u65f6\u5019\uff0c\u6ca1\u6709\u6784\u5efamKwaiRewardAdLoaderListener");
            maxInterstitialAdapterListener.onInterstitialAdLoadFailed(MaxAdapterError.INTERNAL_ERROR);
        }
    }

    private void releaseInterstitial() {
        if (this.mInterstitialLoader != null) {
            this.mInterstitialLoader.release();
            this.mInterstitialLoader = null;
        }
        if (this.mKwaiInterstitialAdLoaderListener != null) {
            this.mKwaiInterstitialAdLoaderListener = null;
        }
    }

    public void loadRewardedAd(@NonNull MaxAdapterResponseParameters maxAdapterResponseParameters, @Nullable Activity activity, @NonNull MaxRewardedAdapterListener maxRewardedAdapterListener) {
        this.logInfo("loadRewardedAd");
        KwaiAdLoaderManager kwaiAdLoaderManager = KwaiAdSDK.getKwaiAdLoaderManager();
        if (kwaiAdLoaderManager != null) {
            this.mKwaiRewardAdLoaderListener = new KwaiRewardAdLoaderListener(this, maxRewardedAdapterListener);
            IKwaiAdLoader rewardAdLoader = kwaiAdLoaderManager.buildRewardAdLoader(new KwaiRewardAdConfig.Builder((AdLoadListener)this.mKwaiRewardAdLoaderListener).withKwaiRewardAdListener((IKwaiRewardAdListener)new KwaiRewardAdListener(this, this, maxRewardedAdapterListener)).build());
            KwaiInitialize kwaiInitialize = new KwaiInitialize((MaxAdapterParameters)maxAdapterResponseParameters);
            String tagId = kwaiInitialize.tagId;
            String floorPrice = kwaiInitialize.floorPrice;
            this.logInfo("loadRewardedAd tagId = " + tagId + ", floorPrice = " + floorPrice);
            KwaiRewardAdRequest kwaiRewardAdRequest = new KwaiRewardAdRequest(tagId);
            this.appendExtInfo((KwaiAdRequest)kwaiRewardAdRequest, floorPrice);
            rewardAdLoader.loadAd((KwaiAdRequest)kwaiRewardAdRequest);
        } else {
            this.logInfo("loadRewardedAd kwaiAdLoaderManager is null");
            maxRewardedAdapterListener.onRewardedAdLoadFailed(MaxAdapterError.NOT_INITIALIZED);
        }
    }

    public void showRewardedAd(@NonNull MaxAdapterResponseParameters maxAdapterResponseParameters, @NonNull Activity activity, @NonNull MaxRewardedAdapterListener maxRewardedAdapterListener) {
        this.logInfo("showRewardedAd");
        this.configureReward(maxAdapterResponseParameters);
        if (this.mKwaiRewardAdLoaderListener != null) {
            if (this.mKwaiRewardAdLoaderListener.adResult != null) {
                KwaiRewardAd adResult = (KwaiRewardAd)this.mKwaiRewardAdLoaderListener.adResult;
                if (adResult.isReady()) {
                    this.logInfo("showRewardedAd ad show");
                    adResult.show(activity);
                } else {
                    this.logInfo("showRewardedAd ad is not ready");
                    maxRewardedAdapterListener.onRewardedAdLoadFailed(MaxAdapterError.AD_NOT_READY);
                }
            } else if (this.mKwaiRewardAdLoaderListener.mKwaiError != null) {
                KwaiError kwaiError = this.mKwaiRewardAdLoaderListener.mKwaiError;
                this.logInfo("showRewardedAd code = " + kwaiError.getCode() + " msg = " + kwaiError.getMsg());
                maxRewardedAdapterListener.onRewardedAdLoadFailed(new MaxAdapterError(kwaiError.getCode(), kwaiError.getMsg()));
            } else {
                this.logInfo("showRewarded time out");
                maxRewardedAdapterListener.onRewardedAdLoadFailed(MaxAdapterError.TIMEOUT);
            }
        } else {
            this.logInfo("showRewardedAd internal error, \u5c55\u793a\u7684\u65f6\u5019\uff0c\u6ca1\u6709\u6784\u5efamKwaiRewardAdLoaderListener");
            maxRewardedAdapterListener.onRewardedAdLoadFailed(MaxAdapterError.INTERNAL_ERROR);
        }
    }

    @Override
    @Nullable
    public MaxReward getMaxReward() {
        return this.getReward();
    }

    private void releaseReward() {
        if (this.mRewardLoader != null) {
            this.mRewardLoader.release();
            this.mRewardLoader = null;
        }
        if (this.mKwaiRewardAdLoaderListener != null) {
            this.mKwaiRewardAdLoaderListener = null;
        }
    }
}

