/*
 * Decompiled with CFR 0.152.
 */
package com.kwai.network.maxadapter.feature.Interstitial;

import androidx.annotation.NonNull;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.listeners.MaxInterstitialAdapterListener;
import com.kwai.network.maxadapter.feature.base.interf.ILogListener;
import com.kwai.network.sdk.constant.KwaiError;
import com.kwai.network.sdk.loader.business.interstitial.interf.IKwaiInterstitialAdListener;

public class KwaiInterstitialAdListener
implements IKwaiInterstitialAdListener {
    @NonNull
    private final ILogListener mLogListener;
    @NonNull
    private final MaxInterstitialAdapterListener mMaxInterstitialAdapterListener;

    public KwaiInterstitialAdListener(@NonNull ILogListener logListener, @NonNull MaxInterstitialAdapterListener maxInterstitialAdapterListener) {
        this.mLogListener = logListener;
        this.mMaxInterstitialAdapterListener = maxInterstitialAdapterListener;
    }

    public void onAdShow() {
        this.mLogListener.logInfo("onAdShow");
        this.mMaxInterstitialAdapterListener.onInterstitialAdDisplayed();
    }

    public void onAdShowFailed(@NonNull KwaiError error) {
        this.mLogListener.logInfo("onAdShowFailed code = " + error.getCode() + " error message = " + error);
        this.mMaxInterstitialAdapterListener.onInterstitialAdDisplayFailed(new MaxAdapterError(error.getCode(), error.getMsg()));
    }

    public void onAdClick() {
        this.mLogListener.logInfo("onAdClick");
        this.mMaxInterstitialAdapterListener.onInterstitialAdClicked();
    }

    public void onAdClose() {
        this.mLogListener.logInfo("onAdClose");
        this.mMaxInterstitialAdapterListener.onInterstitialAdHidden();
    }

    public void onAdPlayComplete() {
        this.mLogListener.logInfo("onAdPlayComplete");
    }
}

