/*
 * Decompiled with CFR 0.152.
 */
package com.kwai.network.maxadapter.feature.reward;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.adapter.MaxAdapterError;
import com.applovin.mediation.adapter.listeners.MaxRewardedAdapterListener;
import com.kwai.network.maxadapter.feature.base.interf.ILogListener;
import com.kwai.network.sdk.constant.KwaiError;
import com.kwai.network.sdk.loader.business.reward.interf.IKwaiRewardAdListener;

public class KwaiRewardAdListener
implements IKwaiRewardAdListener {
    @Nullable
    private final MaxRewardedAdapterListener mMaxRewardedAdapterListener;
    @Nullable
    private final IRewardListener mRewardListener;
    @NonNull
    private final ILogListener mLogListener;

    public KwaiRewardAdListener(@NonNull ILogListener logListener, @Nullable IRewardListener rewardListener, @Nullable MaxRewardedAdapterListener maxRewardedAdapterListener) {
        this.mLogListener = logListener;
        this.mRewardListener = rewardListener;
        this.mMaxRewardedAdapterListener = maxRewardedAdapterListener;
    }

    public void onRewardEarned() {
        MaxReward reward;
        this.mLogListener.logInfo("onRewardEarned");
        MaxReward maxReward = reward = this.mRewardListener == null ? null : this.mRewardListener.getMaxReward();
        if (this.mMaxRewardedAdapterListener != null) {
            this.mMaxRewardedAdapterListener.onUserRewarded(reward);
        }
    }

    public void onAdShow() {
        this.mLogListener.logInfo("onAdShow");
        if (this.mMaxRewardedAdapterListener != null) {
            this.mMaxRewardedAdapterListener.onRewardedAdDisplayed();
        }
    }

    public void onAdShowFailed(@NonNull KwaiError error) {
        this.mLogListener.logInfo("onAdShowFailed code = " + error.getCode() + " error message = " + error);
        if (this.mMaxRewardedAdapterListener != null) {
            this.mMaxRewardedAdapterListener.onRewardedAdDisplayFailed(new MaxAdapterError(error.getCode(), error.getMsg()));
        }
    }

    public void onAdClick() {
        this.mLogListener.logInfo("onAdClick");
        if (this.mMaxRewardedAdapterListener != null) {
            this.mMaxRewardedAdapterListener.onRewardedAdClicked();
        }
    }

    public void onAdClose() {
        this.mLogListener.logInfo("onAdClose");
        if (this.mMaxRewardedAdapterListener != null) {
            this.mMaxRewardedAdapterListener.onRewardedAdHidden();
        }
    }

    public void onAdPlayComplete() {
        this.mLogListener.logInfo("onAdPlayComplete");
        if (this.mMaxRewardedAdapterListener != null) {
            this.mMaxRewardedAdapterListener.onRewardedAdVideoCompleted();
        }
    }

    public static interface IRewardListener {
        @Nullable
        public MaxReward getMaxReward();
    }
}

