/*
 * Copyright (C) 2023 The k-commons Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.github.kylinhunter.commons.collections;

import java.util.Collection;
import java.util.Iterator;

/**
 * @author BiJi'an
 * @description
 * @date 2023-03-19 22:09
 */
public class Iterators {

  /**
   * @param addTo addTo
   * @param iterator iterator
   * @return boolean
   * @title addAll
   * @description
   * @author BiJi'an
   * @date 2023-03-19 22:10
   */
  public static <T> boolean addAll(Collection<T> addTo, Iterator<? extends T> iterator) {
    if (addTo != null && iterator != null) {
      boolean wasModified = false;
      while (iterator.hasNext()) {
        wasModified |= addTo.add(iterator.next());
      }
      return wasModified;
    }
    return false;
  }
}
