/*
 * Copyright (C) 2023 The k-commons Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.github.kylinhunter.commons.component;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author BiJi'an
 * @description
 * @date 2022-10-25 23:17
 */
@Data
@EqualsAndHashCode(onlyExplicitlyIncluded = true)
class CField {

  @EqualsAndHashCode.Include private final Field field;
  private final Object compObject;

  public CField(Field field, Object compObject) {
    this.field = field;
    this.compObject = compObject;
  }

  /**
   * @return java.lang.reflect.Type
   * @title getGenericType
   * @description
   * @author BiJi'an
   * @date 2023-02-12 22:24
   */
  public Type getGenericType() {
    return this.field.getGenericType();
  }

  /**
   * @return java.lang.Class<?>
   * @title getType
   * @description
   * @author BiJi'an
   * @date 2023-02-12 22:24
   */
  public Class<?> getType() {
    return field.getType();
  }
}
