/*
 * Decompiled with CFR 0.152.
 */
package io.github.kylinhunter.commons.cmd;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.github.kylinhunter.commons.cmd.CmdResult;
import io.github.kylinhunter.commons.cmd.CmdResultReader;
import io.github.kylinhunter.commons.collections.ListUtils;
import io.github.kylinhunter.commons.exception.embed.GeneralException;
import io.github.kylinhunter.commons.juc.ThreadPoolExecutorFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class CmdExecutor {
    private ThreadPoolExecutor poolExecutor = ThreadPoolExecutorFactory.register(CmdExecutor.class.getSimpleName(), 5, 10, 10);

    public void setPoolExecutor(ThreadPoolExecutor poolExecutor) {
        if (poolExecutor != null) {
            this.poolExecutor.shutdownNow();
            this.poolExecutor = poolExecutor;
        }
    }

    public List<CmdResult> exec(String ... cmds) {
        ArrayList<CmdResult> cmdResults = ListUtils.newArrayList();
        for (String cmd : cmds) {
            cmdResults.add(this.exec(cmd));
        }
        return cmdResults;
    }

    public CmdResult exec(String cmd) {
        return this.exec(cmd, 60L, TimeUnit.SECONDS);
    }

    @SuppressFBWarnings(value={"COMMAND_INJECTION"})
    public CmdResult exec(String cmd, long timeout, TimeUnit unit) {
        try {
            CmdResult cmdResult = new CmdResult();
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(cmd);
            Future<List<String>> stdOut = this.poolExecutor.submit(new CmdResultReader(process, CmdResultReader.ResultType.STD_OUT));
            Future<List<String>> stdErr = this.poolExecutor.submit(new CmdResultReader(process, CmdResultReader.ResultType.STD_ERR));
            boolean success = process.waitFor(timeout, unit);
            if (success) {
                cmdResult.setExitValue(process.exitValue());
            } else {
                cmdResult.setExitValue(Integer.MIN_VALUE);
            }
            cmdResult.setStdOuts(stdOut.get());
            cmdResult.setStdErrs(stdErr.get());
            return cmdResult;
        }
        catch (Exception e) {
            throw new GeneralException("exec err", (Throwable)e);
        }
    }
}

