/*
 * Decompiled with CFR 0.152.
 */
package io.github.kylinhunter.commons.cmd;

import io.github.kylinhunter.commons.io.Charsets;
import io.github.kylinhunter.commons.io.IOUtil;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.Callable;
import lombok.Generated;

public class CmdResultReader
implements Callable<List<String>> {
    private final Process process;
    private final ResultType type;
    private String charset;

    @Override
    public List<String> call() throws Exception {
        if (this.type == ResultType.STD_OUT) {
            try (InputStream stream = this.process.getInputStream();){
                List<String> list = IOUtil.readLines(stream, Charsets.toCharset(this.charset));
                return list;
            }
        }
        try (InputStream stream = this.process.getErrorStream();){
            List<String> list = IOUtil.readLines(stream, Charsets.toCharset(this.charset));
            return list;
        }
    }

    @Generated
    public CmdResultReader(Process process, ResultType type) {
        this.process = process;
        this.type = type;
    }

    @Generated
    public CmdResultReader(Process process, ResultType type, String charset) {
        this.process = process;
        this.type = type;
        this.charset = charset;
    }

    static enum ResultType {
        STD_OUT,
        STD_ERR;

    }
}

