/*
 * Decompiled with CFR 0.152.
 */
package io.github.kylinhunter.commons.collections;

import io.github.kylinhunter.commons.collections.ListUtils;
import io.github.kylinhunter.commons.collections.StreamUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CollectionUtils {
    public static <T> List<T> merge(boolean reuse, List<T> ... results) {
        List<T> dist = reuse ? null : ListUtils.newArrayList();
        for (List<T> result : results) {
            if (result == null || result.size() <= 0) continue;
            if (dist == null) {
                dist = result;
                continue;
            }
            dist.addAll(result);
        }
        return dist != null ? dist : Collections.EMPTY_LIST;
    }

    public static boolean isEmpty(Collection<?> c) {
        return c == null || c.isEmpty();
    }

    public static <T, C extends Collection<T>> C andFilter(Collection<T> c, Supplier<C> collectionFactory, Predicate<T> ... predicates) {
        return (C)((Collection)StreamUtils.andFilter(c.stream(), predicates).collect(Collectors.toCollection(collectionFactory)));
    }

    public static <T, C extends Collection<T>> C orFilter(Stream<T> stream, Supplier<C> collectionFactory, Predicate<T> ... predicates) {
        return (C)((Collection)StreamUtils.orFilter(stream, predicates).collect(Collectors.toCollection(collectionFactory)));
    }
}

