/*
 * Decompiled with CFR 0.152.
 */
package io.github.kylinhunter.commons.collections;

import io.github.kylinhunter.commons.collections.Iterators;
import io.github.kylinhunter.commons.collections.MapUtils;
import io.github.kylinhunter.commons.exception.check.ThrowChecker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ListUtils {
    private ListUtils() {
    }

    public static <E> ArrayList<E> newArrayList() {
        return new ArrayList();
    }

    public static <E> ArrayList<E> newArrayListWithCapacity(int initialArraySize) {
        ThrowChecker.checkNonnegative(initialArraySize, "initialArraySize");
        return new ArrayList(initialArraySize);
    }

    public static <E> ArrayList<E> newArrayList(E ... elements) {
        if (elements != null) {
            int length = elements.length;
            int capacity = 5 + length + length / 10;
            ArrayList list = new ArrayList(capacity);
            Collections.addAll(list, elements);
            return list;
        }
        return new ArrayList();
    }

    public static <E> ArrayList<E> newArrayList(Iterable<? extends E> elements) {
        if (elements instanceof Collection) {
            return new ArrayList((Collection)elements);
        }
        ArrayList<E> set = ListUtils.newArrayList();
        Iterators.addAll(set, elements.iterator());
        return set;
    }

    public static <E> String toString(List<E> list) {
        return list.stream().map(String::valueOf).collect(Collectors.joining(",", "[", "]"));
    }

    public static <E, C> List<E> sort(List<E> list, Function<E, C> getSortId, List<C> sortIds) {
        HashMap tmpMaps = MapUtils.newHashMap();
        list.forEach(e -> {
            Object tmpC = getSortId.apply(e);
            tmpMaps.put(tmpC, e);
        });
        return sortIds.stream().map(e -> Objects.requireNonNull(tmpMaps.get(e))).collect(Collectors.toList());
    }
}

