/*
 * Decompiled with CFR 0.152.
 */
package io.github.kylinhunter.commons.collections;

import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class MapUtils {
    public static final int MAX_POWER_OF_TWO = 0x40000000;

    private MapUtils() {
    }

    public static <K, V> HashMap<K, V> newHashMap() {
        return new HashMap();
    }

    public static <K, V> HashMap<K, V> newHashMap(int expectedSize) {
        return new HashMap(MapUtils.capacity(expectedSize));
    }

    public static <K, V> ConcurrentMap<K, V> newConcurrentMap() {
        return new ConcurrentHashMap();
    }

    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap() {
        return new LinkedHashMap();
    }

    static int capacity(int expectedSize) {
        if (expectedSize >= 0) {
            if (expectedSize < 3) {
                return expectedSize + 1;
            }
            if (expectedSize < 0x40000000) {
                return (int)((float)expectedSize / 0.75f + 1.0f);
            }
            return Integer.MAX_VALUE;
        }
        return 1;
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static <K extends Comparable, V> TreeMap<K, V> newTreeMap() {
        return new TreeMap();
    }

    public static <K, V> TreeMap<K, V> newTreeMap(SortedMap<K, ? extends V> map) {
        return new TreeMap<K, V>(map);
    }

    public static <C, K extends C, V> TreeMap<K, V> newTreeMap(Comparator<C> comparator) {
        return new TreeMap(comparator);
    }
}

