/*
 * Decompiled with CFR 0.152.
 */
package io.github.kylinhunter.commons.collections;

import io.github.kylinhunter.commons.collections.CollectionUtils;
import io.github.kylinhunter.commons.collections.ListUtils;
import io.github.kylinhunter.commons.collections.SetUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import lombok.Generated;

public class MultiValueMap<K, V> {
    private final Map<K, Collection<V>> map = new HashMap<K, Collection<V>>();
    private boolean removeduplicates = true;

    public MultiValueMap(boolean removeduplicates) {
        this.removeduplicates = removeduplicates;
    }

    public void add(K key, V value) {
        if (key != null && value != null) {
            this.map.compute(key, (k, v) -> {
                if (v == null) {
                    v = this.removeduplicates ? SetUtils.newHashSet() : ListUtils.newArrayList();
                    v.add(value);
                } else {
                    v.add(value);
                }
                return v;
            });
        }
    }

    public Collection<V> getValues(K key) {
        return this.map.get(key);
    }

    public V getValue(K key) {
        Collection<V> values = this.getValues(key);
        if (!CollectionUtils.isEmpty(values)) {
            return values.iterator().next();
        }
        return null;
    }

    public Collection<V> remove(K key) {
        return this.map.remove(key);
    }

    public boolean remove(K key, V v) {
        Collection<V> values = this.getValues(key);
        if (!CollectionUtils.isEmpty(values)) {
            return values.remove(v);
        }
        return false;
    }

    public Collection<V> computeIfAbsent(K key, Function<K, Collection<V>> mappingFunction) {
        return this.map.computeIfAbsent(key, mappingFunction);
    }

    @Generated
    public MultiValueMap() {
    }
}

