/*
 * Decompiled with CFR 0.152.
 */
package io.github.kylinhunter.commons.collections;

import io.github.kylinhunter.commons.collections.Iterators;
import io.github.kylinhunter.commons.collections.MapUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.TreeSet;

public class SetUtils {
    private SetUtils() {
    }

    public static <E> HashSet<E> newHashSet() {
        return new HashSet();
    }

    @SafeVarargs
    public static <E> HashSet<E> newHashSet(E ... elements) {
        HashSet set = new HashSet(MapUtils.capacity(elements.length));
        Collections.addAll(set, elements);
        return set;
    }

    public static <E> HashSet<E> newHashSet(Iterable<? extends E> elements) {
        if (elements instanceof Collection) {
            return new HashSet((Collection)elements);
        }
        HashSet<E> set = SetUtils.newHashSet();
        Iterators.addAll(set, elements.iterator());
        return set;
    }

    public static <E extends Comparable> TreeSet<E> newTreeSet() {
        return new TreeSet();
    }
}

