/*
 * Decompiled with CFR 0.152.
 */
package io.github.kylinhunter.commons.collections;

import io.github.kylinhunter.commons.exception.check.ThrowChecker;
import java.util.Arrays;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class StreamUtils {
    public static <T> Stream<T> andFilter(Stream<T> stream, Predicate<T> ... predicates) {
        ThrowChecker.checkNotNull(stream);
        ThrowChecker.checkNotEmpty(predicates);
        return stream.filter(Arrays.stream(predicates).reduce(t -> true, Predicate::and));
    }

    public static <T> Stream<T> orFilter(Stream<T> stream, Predicate<T> ... predicates) {
        ThrowChecker.checkNotNull(stream);
        ThrowChecker.checkNotEmpty(predicates);
        return stream.filter(Arrays.stream(predicates).reduce(t -> false, Predicate::or));
    }
}

