/*
 * Decompiled with CFR 0.152.
 */
package io.github.kylinhunter.commons.compiler;

import io.github.kylinhunter.commons.collections.ListUtils;
import io.github.kylinhunter.commons.exception.embed.KIOException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import lombok.Generated;

public class KplatCompiler {
    private List<File> sources = ListUtils.newArrayList();
    private File output;

    public void addSource(File file) {
        this.sources.add(file);
    }

    public void addSources(Collection<File> sourceFiles) {
        this.sources.addAll(sourceFiles);
    }

    public boolean compile() {
        boolean bl;
        block8: {
            JavaCompiler javaCompiler = ToolProvider.getSystemJavaCompiler();
            StandardJavaFileManager fileManager = javaCompiler.getStandardFileManager(null, null, null);
            try {
                Iterable<? extends JavaFileObject> fileObjects = fileManager.getJavaFileObjects(this.sources.toArray(new File[0]));
                List<String> options = Arrays.asList("-d", this.output.getAbsolutePath());
                JavaCompiler.CompilationTask cTask = javaCompiler.getTask(null, fileManager, null, options, null, fileObjects);
                bl = cTask.call();
                if (fileManager == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (fileManager != null) {
                        try {
                            fileManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new KIOException("compile error", (Throwable)e);
                }
            }
            fileManager.close();
        }
        return bl;
    }

    public static void findClassPath(String prefix, Set<String> paths) throws IOException {
        ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
        Enumeration<URL> resources = systemClassLoader.getResources(prefix);
        while (resources.hasMoreElements()) {
            String file;
            URL url = resources.nextElement();
            if (url.getProtocol().equals("jar")) {
                file = url.getFile();
                int index = file.indexOf(".jar");
                paths.add(file.substring(0, index) + ".jar");
                continue;
            }
            file = url.getFile();
            paths.add(file.substring(0, file.length() - prefix.length() - 1));
        }
    }

    @Generated
    public List<File> getSources() {
        return this.sources;
    }

    @Generated
    public File getOutput() {
        return this.output;
    }

    @Generated
    public void setSources(List<File> sources) {
        this.sources = sources;
    }

    @Generated
    public void setOutput(File output) {
        this.output = output;
    }
}

