/*
 * Decompiled with CFR 0.152.
 */
package io.github.kylinhunter.commons.component;

import io.github.kylinhunter.commons.collections.CollectionUtils;
import io.github.kylinhunter.commons.collections.ListUtils;
import io.github.kylinhunter.commons.collections.SetUtils;
import io.github.kylinhunter.commons.component.CAfter;
import io.github.kylinhunter.commons.component.CAfterMethod;
import io.github.kylinhunter.commons.component.CConstructorManager;
import io.github.kylinhunter.commons.component.CMethodManager;
import io.github.kylinhunter.commons.component.CompManager;
import io.github.kylinhunter.commons.reflect.ReflectUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.reflections.ReflectionUtils;

class CAfterMethodCalculator {
    private CConstructorManager constructorManager;
    private CMethodManager methodManager;
    private CompManager compManager;

    public CAfterMethodCalculator(CompManager compManager) {
        this.compManager = compManager;
        this.constructorManager = compManager.constructorCompManager.constructorManager;
        this.methodManager = compManager.methodCompManager.methodManager;
    }

    public void calculate() {
        List<CAfterMethod> allCAfterMethods = this.getAllCAfterMethods();
        for (CAfterMethod afterMethod : allCAfterMethods) {
            ReflectUtils.invoke(afterMethod.getCompObject(), afterMethod.getMethod(), new Object[0]);
        }
    }

    private List<CAfterMethod> getAllCAfterMethods() {
        ArrayList<CAfterMethod> allCAfterMethods = ListUtils.newArrayList();
        HashSet<Class<?>> allCompClasses = SetUtils.newHashSet(this.constructorManager.getCompClasses());
        allCompClasses.addAll(this.methodManager.getCompClasses());
        for (Class clazz : allCompClasses) {
            Object o = this.compManager.get(clazz, true);
            Set methods = ReflectionUtils.getAllMethods((Class)clazz, (Predicate[])new Predicate[]{m -> m.getAnnotation(CAfter.class) != null});
            if (CollectionUtils.isEmpty(methods)) continue;
            Set cafterMethods = methods.stream().map(m -> new CAfterMethod((Method)m, o, m.getAnnotation(CAfter.class))).collect(Collectors.toSet());
            allCAfterMethods.addAll(cafterMethods);
        }
        return allCAfterMethods;
    }

    @Generated
    public CAfterMethodCalculator() {
    }
}

