/*
 * Decompiled with CFR 0.152.
 */
package io.github.kylinhunter.commons.component;

import io.github.kylinhunter.commons.collections.MapUtils;
import io.github.kylinhunter.commons.collections.SetUtils;
import io.github.kylinhunter.commons.component.CConstructor;
import io.github.kylinhunter.commons.component.CConstructorManager;
import io.github.kylinhunter.commons.reflect.GenericTypeUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class CConstructorDepCalculator {
    private final Map<CConstructor, Set<CConstructor>> dependencies = MapUtils.newHashMap();
    private final CConstructorManager constructorManager;

    public CConstructorDepCalculator(CConstructorManager constructorManager) {
        this.constructorManager = constructorManager;
    }

    public void clean() {
        this.dependencies.clear();
    }

    public List<CConstructor> calculate(List<CConstructor> constructors) {
        this.clean();
        for (CConstructor cconstructor : constructors) {
            this.calculate(cconstructor);
        }
        return constructors.stream().sorted(Comparator.comparingInt(CConstructor::getDepLevel)).collect(Collectors.toList());
    }

    private void calculate(CConstructor cconstructor) {
        this.calculate(cconstructor, SetUtils.newHashSet(cconstructor));
        cconstructor.setDepLevel(this.dependencies.get(cconstructor).size());
    }

    private void calculate(CConstructor oriCConstructor, Set<CConstructor> depCConstructors) {
        if (depCConstructors.size() <= 0) {
            return;
        }
        for (CConstructor curConstructor : depCConstructors) {
            this.dependencies.compute(oriCConstructor, (k, v) -> {
                if (v == null) {
                    v = SetUtils.newHashSet();
                }
                v.add(curConstructor);
                return v;
            });
            Constructor<?> constructor = curConstructor.getConstructor();
            if (constructor.getParameterCount() <= 0) continue;
            HashSet<CConstructor> tmpCConstructors = SetUtils.newHashSet();
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            Type[] genericParameterTypes = constructor.getGenericParameterTypes();
            for (int i = 0; i < parameterTypes.length; ++i) {
                Class<?> curParametorClass = parameterTypes[i];
                if (Collection.class.isAssignableFrom(curParametorClass)) {
                    Class<?>[] actualTypeArgumentClasses;
                    Type type = genericParameterTypes[i];
                    for (Class<?> actualTypeArgumentClass : actualTypeArgumentClasses = GenericTypeUtils.getActualTypeArguments(type)) {
                        tmpCConstructors.addAll(this.constructorManager.getAll(actualTypeArgumentClass));
                    }
                } else {
                    tmpCConstructors.add(this.constructorManager.get(curParametorClass, true));
                }
                this.calculate(oriCConstructor, tmpCConstructors);
            }
        }
    }
}

