/*
 * Decompiled with CFR 0.152.
 */
package io.github.kylinhunter.commons.component;

import io.github.kylinhunter.commons.collections.ListUtils;
import io.github.kylinhunter.commons.collections.MapUtils;
import io.github.kylinhunter.commons.collections.SetUtils;
import io.github.kylinhunter.commons.component.C;
import io.github.kylinhunter.commons.component.CConstructor;
import io.github.kylinhunter.commons.component.CConstructorDepCalculator;
import io.github.kylinhunter.commons.component.CompManager;
import io.github.kylinhunter.commons.exception.embed.InitException;
import io.github.kylinhunter.commons.init.ClassScanner;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;

class CConstructorManager {
    private final Map<Class<?>, List<CConstructor>> constructorsMap = MapUtils.newHashMap();
    private List<CConstructor> constructors = ListUtils.newArrayList();
    private final Set<Class<?>> compClasses = SetUtils.newHashSet();
    private final ClassScanner classScanner;
    private final CConstructorDepCalculator constructorDepCalculator;

    public CConstructorManager(CompManager compManager) {
        this.classScanner = compManager.classScanner;
        this.constructorDepCalculator = new CConstructorDepCalculator(this);
    }

    public void clean() {
        this.constructorsMap.clear();
        this.constructors.clear();
        this.compClasses.clear();
    }

    public void calculate() {
        this.clean();
        Set<Class<?>> compClazzes = this.classScanner.getClassesByAnnotatedWith(C.class);
        for (Class<?> compClazz : compClazzes) {
            this.calculate(compClazz);
        }
        this.constructors = this.constructorDepCalculator.calculate(this.constructors);
    }

    private void calculate(Class<?> compClazz) {
        C c = compClazz.getAnnotation(C.class);
        CConstructor cconstructor = new CConstructor(compClazz, c);
        this.compClasses.add(compClazz);
        this.constructors.add(cconstructor);
        this.registerAll(compClazz, cconstructor);
    }

    private void registerAll(Class<?> compClazz, CConstructor cconstructor) {
        this.register(compClazz, cconstructor);
        Set<Class<?>> interfaces = this.classScanner.getAllInterface(compClazz);
        for (Class<?> interfaceClazz : interfaces) {
            this.register(interfaceClazz, cconstructor);
        }
    }

    private void register(Class<?> clazz, CConstructor cconstructor) {
        this.constructorsMap.compute(clazz, (k, v) -> {
            if (v == null) {
                v = ListUtils.newArrayList();
            }
            if (!v.contains(cconstructor)) {
                if (cconstructor.isPrimary()) {
                    v.add(0, cconstructor);
                } else {
                    v.add(cconstructor);
                }
            }
            return v;
        });
    }

    public CConstructor get(Class<?> compClazz) {
        return this.get(compClazz, false);
    }

    public CConstructor get(Class<?> compClazz, boolean required) {
        List<CConstructor> constructors = this.constructorsMap.get(compClazz);
        if (constructors != null && constructors.size() > 0) {
            return constructors.get(0);
        }
        if (required) {
            throw new InitException(" no cconstructor " + compClazz.getName());
        }
        return null;
    }

    public List<CConstructor> getAll(Class<?> compClazz) {
        List<CConstructor> cConstructors = this.constructorsMap.get(compClazz);
        if (cConstructors != null) {
            return cConstructors;
        }
        return Collections.emptyList();
    }

    @Generated
    public List<CConstructor> getConstructors() {
        return this.constructors;
    }

    @Generated
    public Set<Class<?>> getCompClasses() {
        return this.compClasses;
    }
}

