/*
 * Decompiled with CFR 0.152.
 */
package io.github.kylinhunter.commons.component;

import io.github.kylinhunter.commons.collections.CollectionUtils;
import io.github.kylinhunter.commons.collections.ListUtils;
import io.github.kylinhunter.commons.collections.SetUtils;
import io.github.kylinhunter.commons.component.CConstructorManager;
import io.github.kylinhunter.commons.component.CField;
import io.github.kylinhunter.commons.component.CMethodManager;
import io.github.kylinhunter.commons.component.CSet;
import io.github.kylinhunter.commons.component.CompManager;
import io.github.kylinhunter.commons.exception.embed.InitException;
import io.github.kylinhunter.commons.reflect.GenericTypeUtils;
import io.github.kylinhunter.commons.reflect.ReflectUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.reflections.ReflectionUtils;

class CFieldCompSetter {
    private CConstructorManager constructorManager;
    private CMethodManager methodManager;
    private CompManager compManager;

    public CFieldCompSetter(CompManager compManager) {
        this.compManager = compManager;
        this.constructorManager = compManager.constructorCompManager.constructorManager;
        this.methodManager = compManager.methodCompManager.methodManager;
    }

    public void calculate() {
        List<CField> allCFields = this.getAllCFields();
        for (CField cfield : allCFields) {
            Object value;
            Class<?> compClazz = cfield.getType();
            Field field = cfield.getField();
            Object compObject = cfield.getCompObject();
            if (List.class.isAssignableFrom(compClazz)) {
                Class actualTypeArgumentClasses = GenericTypeUtils.getActualTypeArgument(cfield.getGenericType(), 0);
                value = this.compManager.getAll(actualTypeArgumentClasses, true);
                ReflectUtils.setField(compObject, field, value);
            } else {
                value = this.compManager.get(compClazz, false);
                if (value == null) {
                    throw new InitException(compObject.getClass().getName() + " can't set " + compClazz.getName());
                }
            }
            ReflectUtils.setField(compObject, field, value);
        }
    }

    private List<CField> getAllCFields() {
        ArrayList<CField> allCFields = ListUtils.newArrayList();
        HashSet<Class<?>> allCompClasses = SetUtils.newHashSet(this.constructorManager.getCompClasses());
        allCompClasses.addAll(this.methodManager.getCompClasses());
        for (Class clazz : allCompClasses) {
            Object o = this.compManager.get(clazz, true);
            Set fields = ReflectionUtils.getAllFields((Class)clazz, (Predicate[])new Predicate[]{f -> f.getAnnotation(CSet.class) != null});
            if (CollectionUtils.isEmpty(fields)) continue;
            Set cFields = fields.stream().map(e -> new CField((Field)e, o)).collect(Collectors.toSet());
            allCFields.addAll(cFields);
        }
        return allCFields;
    }

    @Generated
    public CFieldCompSetter() {
    }
}

