/*
 * Decompiled with CFR 0.152.
 */
package io.github.kylinhunter.commons.component;

import io.github.kylinhunter.commons.collections.MapUtils;
import io.github.kylinhunter.commons.collections.SetUtils;
import io.github.kylinhunter.commons.component.CMethod;
import io.github.kylinhunter.commons.component.CMethodManager;
import io.github.kylinhunter.commons.exception.embed.InitException;
import io.github.kylinhunter.commons.reflect.GenericTypeUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class CMethodDepCalculator {
    private final Map<CMethod, Set<CMethod>> dependencies = MapUtils.newHashMap();
    private final CMethodManager methodManager;

    public CMethodDepCalculator(CMethodManager methodManager) {
        this.methodManager = methodManager;
    }

    public void clean() {
        this.dependencies.clear();
    }

    public List<CMethod> calculate(List<CMethod> cmethods) {
        this.clean();
        for (CMethod cmethod : this.methodManager.getCmethods()) {
            this.calculate(cmethod);
        }
        return cmethods.stream().sorted(Comparator.comparingInt(CMethod::getDepLevel)).collect(Collectors.toList());
    }

    private void calculate(CMethod cmethod) {
        this.calculate(cmethod, SetUtils.newHashSet(cmethod));
        cmethod.setDepLevel(this.dependencies.get(cmethod).size());
    }

    private void calculate(CMethod oriCmethod, Set<CMethod> depCMethods) {
        if (depCMethods.size() <= 0) {
            return;
        }
        for (CMethod cmethod : depCMethods) {
            this.dependencies.compute(oriCmethod, (k, v) -> {
                if (v == null) {
                    v = SetUtils.newHashSet();
                }
                v.add(cmethod);
                return v;
            });
            Method method = cmethod.getMethod();
            if (method.getParameterCount() <= 0) continue;
            try {
                HashSet<CMethod> tmpCMethods = SetUtils.newHashSet();
                Class<?>[] parameterTypes = method.getParameterTypes();
                Type[] genericParameterTypes = method.getGenericParameterTypes();
                for (int i = 0; i < parameterTypes.length; ++i) {
                    Class<?> curParametorClass = parameterTypes[i];
                    if (Collection.class.isAssignableFrom(curParametorClass)) {
                        Class<?>[] actualTypeArgumentClasses;
                        Type type = genericParameterTypes[i];
                        for (Class<?> actualTypeArgumentClass : actualTypeArgumentClasses = GenericTypeUtils.getActualTypeArguments(type)) {
                            List<CMethod> all = this.methodManager.getAll(actualTypeArgumentClass);
                            tmpCMethods.addAll(all);
                        }
                    } else {
                        tmpCMethods.add(this.methodManager.get(curParametorClass, true));
                    }
                    this.calculate(oriCmethod, tmpCMethods);
                }
            }
            catch (Exception e) {
                throw new InitException("init method error" + method, (Throwable)e);
            }
        }
    }
}

