/*
 * Decompiled with CFR 0.152.
 */
package io.github.kylinhunter.commons.component;

import io.github.kylinhunter.commons.collections.ListUtils;
import io.github.kylinhunter.commons.collections.MapUtils;
import io.github.kylinhunter.commons.collections.SetUtils;
import io.github.kylinhunter.commons.component.C;
import io.github.kylinhunter.commons.component.CC;
import io.github.kylinhunter.commons.component.CMethod;
import io.github.kylinhunter.commons.component.CMethodDepCalculator;
import io.github.kylinhunter.commons.component.CompManager;
import io.github.kylinhunter.commons.exception.embed.InitException;
import io.github.kylinhunter.commons.init.ClassScanner;
import io.github.kylinhunter.commons.reflect.ObjectCreator;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import lombok.Generated;
import org.reflections.ReflectionUtils;

class CMethodManager {
    private final Map<Class<?>, List<CMethod>> cmethodsMap = MapUtils.newHashMap();
    private List<CMethod> cmethods = ListUtils.newArrayList();
    private final CompManager compManager;
    private final ClassScanner classScanner;
    private final CMethodDepCalculator methodDepCalculator;
    private final Set<Class<?>> compClasses = SetUtils.newHashSet();

    public CMethodManager(CompManager compManager) {
        this.compManager = compManager;
        this.classScanner = compManager.classScanner;
        this.methodDepCalculator = new CMethodDepCalculator(this);
    }

    public void clean() {
        this.cmethodsMap.clear();
        this.cmethods.clear();
        this.compClasses.clear();
    }

    public void calculate() {
        this.clean();
        Set<Class<?>> ccClasses = this.classScanner.getClassesByAnnotatedWith(CC.class);
        for (Class<?> ccClazz : ccClasses) {
            this.calculate(ccClazz);
        }
        this.cmethods = this.methodDepCalculator.calculate(this.cmethods);
    }

    private void calculate(Class<?> compClazz) {
        Object ccObject = ObjectCreator.create(compClazz);
        this.compManager.register(compClazz, ccObject);
        Set methods = ReflectionUtils.getAllMethods(compClazz, (Predicate[])new Predicate[0]);
        for (Method method : methods) {
            C c = method.getAnnotation(C.class);
            if (c == null) continue;
            CMethod cmethod = new CMethod(method, ccObject, c);
            this.compClasses.add(method.getReturnType());
            this.cmethods.add(cmethod);
            this.registerAll(method.getReturnType(), cmethod);
        }
    }

    private void registerAll(Class<?> compClazz, CMethod cmethod) {
        this.register(compClazz, cmethod);
        Set<Class<?>> interfaces = this.classScanner.getAllInterface(compClazz);
        for (Class<?> interfaceClazz : interfaces) {
            this.register(interfaceClazz, cmethod);
        }
    }

    private void register(Class<?> clazz, CMethod cmethod) {
        this.cmethodsMap.compute(clazz, (k, v) -> {
            if (v == null) {
                v = ListUtils.newArrayList();
            }
            if (!v.contains(cmethod)) {
                if (cmethod.isPrimary()) {
                    v.add(0, cmethod);
                } else {
                    v.add(cmethod);
                }
            }
            return v;
        });
    }

    public CMethod get(Class<?> compClazz) {
        return this.get(compClazz, false);
    }

    public CMethod get(Class<?> compClazz, boolean required) {
        List<CMethod> methods = this.cmethodsMap.get(compClazz);
        if (methods != null && methods.size() > 0) {
            return methods.get(0);
        }
        if (required) {
            throw new InitException(" no cmethods " + compClazz.getName());
        }
        return null;
    }

    public List<CMethod> getAll(Class<?> compClazz) {
        List<CMethod> cConstructors = this.cmethodsMap.get(compClazz);
        return Objects.requireNonNullElse(cConstructors, Collections.emptyList());
    }

    @Generated
    public List<CMethod> getCmethods() {
        return this.cmethods;
    }

    @Generated
    public Set<Class<?>> getCompClasses() {
        return this.compClasses;
    }
}

