/*
 * Decompiled with CFR 0.152.
 */
package io.github.kylinhunter.commons.component;

import io.github.kylinhunter.commons.collections.ListUtils;
import io.github.kylinhunter.commons.component.CObject;
import io.github.kylinhunter.commons.exception.embed.InitException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public class CObjects {
    private int order;
    private boolean hasPrimary;
    private List<Object> objects = ListUtils.newArrayList();
    private List<CObject> cobjects = ListUtils.newArrayList();

    public void add(CObject cobject) {
        if (cobject.isPrimary()) {
            if (!this.hasPrimary) {
                this.hasPrimary = true;
            } else {
                throw new InitException("duplicate primary object");
            }
        }
        if (!this.cobjects.contains(cobject)) {
            this.cobjects.add(cobject);
            Collections.sort(this.cobjects, Comparator.comparingInt(CObject::getOrder));
            this.objects = this.cobjects.stream().map(e -> e.getObject()).collect(Collectors.toList());
        }
    }

    public boolean isEmpty() {
        return this.objects.isEmpty();
    }

    public Object getObject() {
        if (this.objects != null) {
            return this.objects.get(0);
        }
        return null;
    }

    @Generated
    public CObjects() {
    }

    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public boolean isHasPrimary() {
        return this.hasPrimary;
    }

    @Generated
    public List<Object> getObjects() {
        return this.objects;
    }

    @Generated
    public List<CObject> getCobjects() {
        return this.cobjects;
    }

    @Generated
    public void setOrder(int order) {
        this.order = order;
    }

    @Generated
    public void setHasPrimary(boolean hasPrimary) {
        this.hasPrimary = hasPrimary;
    }

    @Generated
    public void setObjects(List<Object> objects) {
        this.objects = objects;
    }

    @Generated
    public void setCobjects(List<CObject> cobjects) {
        this.cobjects = cobjects;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CObjects)) {
            return false;
        }
        CObjects other = (CObjects)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getOrder() != other.getOrder()) {
            return false;
        }
        if (this.isHasPrimary() != other.isHasPrimary()) {
            return false;
        }
        List<Object> this$objects = this.getObjects();
        List<Object> other$objects = other.getObjects();
        if (this$objects == null ? other$objects != null : !((Object)this$objects).equals(other$objects)) {
            return false;
        }
        List<CObject> this$cobjects = this.getCobjects();
        List<CObject> other$cobjects = other.getCobjects();
        return !(this$cobjects == null ? other$cobjects != null : !((Object)this$cobjects).equals(other$cobjects));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CObjects;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getOrder();
        result = result * 59 + (this.isHasPrimary() ? 79 : 97);
        List<Object> $objects = this.getObjects();
        result = result * 59 + ($objects == null ? 43 : ((Object)$objects).hashCode());
        List<CObject> $cobjects = this.getCobjects();
        result = result * 59 + ($cobjects == null ? 43 : ((Object)$cobjects).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CObjects(order=" + this.getOrder() + ", hasPrimary=" + this.isHasPrimary() + ", objects=" + this.getObjects() + ", cobjects=" + this.getCobjects() + ")";
    }
}

