/*
 * Decompiled with CFR 0.152.
 */
package io.github.kylinhunter.commons.component;

import io.github.kylinhunter.commons.collections.ListUtils;
import io.github.kylinhunter.commons.collections.MapUtils;
import io.github.kylinhunter.commons.component.CAfterMethodCalculator;
import io.github.kylinhunter.commons.component.CConstructor;
import io.github.kylinhunter.commons.component.CFieldCompSetter;
import io.github.kylinhunter.commons.component.CMethod;
import io.github.kylinhunter.commons.component.CObject;
import io.github.kylinhunter.commons.component.CObjects;
import io.github.kylinhunter.commons.component.ConstructorCompManager;
import io.github.kylinhunter.commons.component.MethodCompManager;
import io.github.kylinhunter.commons.exception.embed.InitException;
import io.github.kylinhunter.commons.init.ClassScanner;
import io.github.kylinhunter.commons.lang.strings.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CompManager.class);
    protected final Map<Object, CObjects> allComponents = MapUtils.newHashMap();
    protected ClassScanner classScanner;
    protected final ConstructorCompManager constructorCompManager;
    protected final MethodCompManager methodCompManager;
    private final CFieldCompSetter cfieldCompSetter;
    private final CAfterMethodCalculator cafterMethodCalculator;

    public CompManager(ClassScanner classScanner) {
        this.classScanner = classScanner;
        this.constructorCompManager = new ConstructorCompManager(this);
        this.methodCompManager = new MethodCompManager(this);
        this.cfieldCompSetter = new CFieldCompSetter(this);
        this.cafterMethodCalculator = new CAfterMethodCalculator(this);
    }

    public void init() {
        try {
            this.allComponents.clear();
            this.calComponent();
        }
        catch (Throwable e) {
            throw new InitException("init CompManager error", e);
        }
    }

    public void calComponent() {
        this.constructorCompManager.calculate();
        this.methodCompManager.calculate();
        this.cfieldCompSetter.calculate();
        this.cafterMethodCalculator.calculate();
    }

    public <T> List<T> getAll(Class<T> compClazz, boolean required) {
        Objects.requireNonNull(compClazz, "clazz can't be null");
        CObjects cobjects = this.allComponents.get(compClazz);
        if (cobjects != null && !cobjects.isEmpty()) {
            return cobjects.getObjects();
        }
        if (required) {
            throw new InitException("no component for :" + compClazz);
        }
        return null;
    }

    public <T> T get(Object key, boolean required) {
        Objects.requireNonNull(key, "key can't be null");
        CObjects cobjects = this.allComponents.get(key);
        if (cobjects != null && !cobjects.isEmpty()) {
            return (T)cobjects.getObject();
        }
        if (required) {
            throw new InitException("no component for :" + key);
        }
        return null;
    }

    public List<CObjects> register(Class<?> clazz, CConstructor cconstructor, Object obj) {
        log.info("register {},{}", (Object)clazz.getName(), (Object)cconstructor.toString());
        CObject cobject = new CObject(cconstructor, obj);
        return this.register(clazz, cobject);
    }

    public List<CObjects> register(Class<?> clazz, CMethod cmethod, Object obj) {
        CObject cobject = new CObject(cmethod, obj);
        return this.register(clazz, cobject);
    }

    public List<CObjects> register(Class<?> clazz, Object obj) {
        CObject cobject = new CObject(true, 0, clazz.getSimpleName(), obj);
        return this.register(clazz, cobject);
    }

    private List<CObjects> register(Class<?> clazz, CObject cobject) {
        try {
            ArrayList<CObjects> allAffectedCObjects = ListUtils.newArrayList();
            CObjects affectedCObject = this.allComponents.compute(clazz, (k, cobjects) -> {
                if (cobjects == null) {
                    cobjects = new CObjects();
                }
                cobjects.add(cobject);
                return cobjects;
            });
            this.register(clazz.getSimpleName(), cobject);
            String name = cobject.getName();
            if (!StringUtil.isEmpty(name) && !name.equals(clazz.getSimpleName())) {
                this.register(name, cobject);
            }
            allAffectedCObjects.add(affectedCObject);
            Set<Class<?>> allInterfaces = this.classScanner.getAllInterface(clazz);
            if (allInterfaces != null && allInterfaces.size() > 0) {
                for (Class<?> iterfaceClass : allInterfaces) {
                    CObjects affectedCObjects = this.allComponents.compute(iterfaceClass, (k, cobjects) -> {
                        if (cobjects == null) {
                            cobjects = new CObjects();
                        }
                        cobjects.add(cobject);
                        return cobjects;
                    });
                    allAffectedCObjects.add(affectedCObjects);
                }
            }
            return allAffectedCObjects;
        }
        catch (Exception e) {
            throw new InitException("init components error:" + clazz.getName(), (Throwable)e);
        }
    }

    public void check(Set<Class<?>> compClazzes) {
        for (Class<?> compClazz : compClazzes) {
            if (this.get(compClazz, false) != null) continue;
            throw new InitException("no    component be initialized " + compClazz.getName());
        }
    }

    public void register(String name, Object obj) {
        CObjects objects = new CObjects();
        objects.add(new CObject(name, obj));
        this.allComponents.put(name, objects);
    }

    private void register(String name, CObject cobject) {
        if (!StringUtil.isEmpty(name)) {
            CObjects cObjects = this.allComponents.get(name);
            if (cObjects != null) {
                throw new InitException("invalid cobject name:" + cobject.getName());
            }
            CObjects objects = new CObjects();
            objects.add(cobject);
            this.allComponents.put(name, objects);
        }
    }

    @Generated
    public ClassScanner getClassScanner() {
        return this.classScanner;
    }
}

