/*
 * Decompiled with CFR 0.152.
 */
package io.github.kylinhunter.commons.component;

import io.github.kylinhunter.commons.component.CConstructor;
import io.github.kylinhunter.commons.component.CConstructorManager;
import io.github.kylinhunter.commons.component.CompManager;
import io.github.kylinhunter.commons.exception.embed.InitException;
import io.github.kylinhunter.commons.reflect.GenericTypeUtils;
import io.github.kylinhunter.commons.reflect.ObjectCreator;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConstructorCompManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConstructorCompManager.class);
    private final CompManager compManager;
    protected final CConstructorManager constructorManager;

    public ConstructorCompManager(CompManager compManager) {
        this.compManager = compManager;
        this.constructorManager = new CConstructorManager(compManager);
    }

    public void calculate() {
        this.constructorManager.calculate();
        List<CConstructor> cconstructors = this.constructorManager.getConstructors();
        for (CConstructor cconstructor : cconstructors) {
            this.calculate(cconstructor);
        }
        this.compManager.check(this.constructorManager.getCompClasses());
    }

    public void calculate(CConstructor cconstructor) {
        Constructor<?> constructor = cconstructor.getConstructor();
        Class<?> clazz = cconstructor.getClazz();
        int parameterCount = constructor.getParameterCount();
        if (parameterCount <= 0) {
            this.compManager.register(clazz, cconstructor, ObjectCreator.create(constructor, new Object[0]));
        } else {
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            Type[] genericParameterTypes = constructor.getGenericParameterTypes();
            Object[] parameterObj = new Object[parameterCount];
            for (int i = 0; i < parameterCount; ++i) {
                Type type;
                Class argClass;
                List comps;
                Class<?> curParametorClass = parameterTypes[i];
                Object obj = this.compManager.get(curParametorClass, false);
                if (obj != null) {
                    parameterObj[i] = obj;
                } else if (List.class.isAssignableFrom(curParametorClass) && (comps = this.compManager.getAll(argClass = GenericTypeUtils.getActualTypeArgument(type = genericParameterTypes[i], 0), false)).size() > 0) {
                    parameterObj[i] = comps;
                }
                if (parameterObj[i] != null) continue;
                throw new InitException("no component:" + clazz.getName());
            }
            this.compManager.register(clazz, cconstructor, ObjectCreator.create(constructor, parameterObj));
        }
    }

    @Generated
    public ConstructorCompManager(CompManager compManager, CConstructorManager constructorManager) {
        this.compManager = compManager;
        this.constructorManager = constructorManager;
    }
}

